/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer.predicates;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.util.math.MathHelper;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;

public class SizePredicate
implements IModelLayerPredicate {
    public final float min;
    public final float max;

    public SizePredicate(float min, float max) {
        this.min = MathHelper.func_76131_a((float)min, (float)0.0f, (float)2.1474836E9f);
        this.max = MathHelper.func_76131_a((float)max, (float)0.0f, (float)2.1474836E9f);
        if (min > max) {
            throw new IllegalStateException("Min size cant be bigger than max size!");
        }
    }

    @Override
    public boolean test(IModelLayerContext context) {
        AtomicReference<Float> size = new AtomicReference<Float>(Float.valueOf(1.0f));
        context.getAsEntity().getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> size.set(Float.valueOf(sizeChanging.getScale())));
        return size.get().floatValue() >= this.min && size.get().floatValue() <= this.max;
    }
}

