/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.transformer.ITextureTransformer;

public class AlphaMaskTextureTransformer
implements ITextureTransformer {
    private final String maskLocation;

    public AlphaMaskTextureTransformer(String maskLocation) {
        this.maskLocation = maskLocation;
    }

    @Override
    public NativeImage transform(NativeImage texture, IResourceManager manager, Function<String, String> stringConverter) throws IOException {
        NativeImage overlay = NativeImage.func_195713_a((InputStream)manager.func_199002_a(new ResourceLocation(stringConverter.apply(this.maskLocation))).func_199027_b());
        for (int y = 0; y < overlay.func_195714_b(); ++y) {
            for (int x = 0; x < overlay.func_195702_a(); ++x) {
                int pixelOrig = texture.func_195709_a(x, y);
                int pixelMask = overlay.func_195709_a(x, y);
                if (pixelOrig == 0) continue;
                Color color = new Color(pixelMask, true);
                Color colorOrig = new Color(pixelOrig, true);
                float hue = 1.0f - (float)(color.getRed() + color.getGreen() + color.getBlue()) / 3.0f / 255.0f;
                int newAlpha = pixelMask == 0 ? 0 : (int)((float)colorOrig.getAlpha() * hue);
                Color newColor = new Color(colorOrig.getRed(), colorOrig.getGreen(), colorOrig.getBlue(), newAlpha);
                texture.func_195700_a(x, y, newColor.getRGB());
            }
        }
        return texture;
    }
}

