/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class AlphaMaskTexture
extends SimpleTexture {
    private final ResourceLocation maskLocation;

    public AlphaMaskTexture(ResourceLocation texture, ResourceLocation maskLocation) {
        super(texture);
        this.maskLocation = maskLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195413_a(IResourceManager manager) throws IOException {
        this.func_147631_c();
        InputStream textureStream = null;
        InputStream maskStream = null;
        try {
            textureStream = manager.func_199002_a(this.field_110568_b).func_199027_b();
            NativeImage image = NativeImage.func_195713_a((InputStream)textureStream);
            maskStream = manager.func_199002_a(this.maskLocation).func_199027_b();
            NativeImage overlay = NativeImage.func_195713_a((InputStream)maskStream);
            for (int y = 0; y < overlay.func_195714_b(); ++y) {
                for (int x = 0; x < overlay.func_195702_a(); ++x) {
                    int pixelOrig = image.func_195709_a(x, y);
                    int pixelMask = overlay.func_195709_a(x, y);
                    if (pixelOrig == 0) continue;
                    Color color = new Color(pixelMask, true);
                    Color colorOrig = new Color(pixelOrig, true);
                    float hue = 1.0f - (float)(color.getRed() + color.getGreen() + color.getBlue()) / 3.0f / 255.0f;
                    int newAlpha = pixelMask == 0 ? 0 : (int)((float)colorOrig.getAlpha() * hue);
                    Color newColor = new Color(colorOrig.getRed(), colorOrig.getGreen(), colorOrig.getBlue(), newAlpha);
                    image.func_195700_a(x, y, newColor.getRGB());
                }
            }
            TextureUtil.prepareImage((int)this.func_110552_b(), (int)image.func_195702_a(), (int)image.func_195714_b());
            image.func_195697_a(0, 0, 0, false);
        }
        finally {
            if (textureStream != null) {
                textureStream.close();
            }
            if (maskStream != null) {
                maskStream.close();
            }
        }
    }
}

