/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.threetag.threecore.capability.CapabilityKarma;
import net.threetag.threecore.karma.KarmaClass;

public class KarmaCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"karma").requires(player -> player.func_197034_c(2))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)-1000, (int)1000)).executes(c -> KarmaCommand.setKarma((CommandSource)c.getSource(), EntityArgument.func_197090_e((CommandContext)c, (String)"players"), IntegerArgumentType.getInteger((CommandContext)c, (String)"value"))))))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(c -> KarmaCommand.sendKarmaInfo((CommandSource)c.getSource(), (PlayerEntity)EntityArgument.func_197089_d((CommandContext)c, (String)"player")))));
    }

    private static int setKarma(CommandSource commandSource, Collection<ServerPlayerEntity> players, int karma) {
        Iterator<ServerPlayerEntity> iterator = players.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            PlayerEntity pl = (PlayerEntity)iterator.next();
            CapabilityKarma.setKarma(pl, karma);
            if (!pl.getCapability(CapabilityKarma.KARMA).isPresent()) continue;
            ++i;
        }
        if (i == 1) {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.karma.success.player.single", new Object[]{players.iterator().next().func_145748_c_(), karma}), true);
        } else {
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.karma.success.player.multiple", new Object[]{i, karma}), true);
        }
        return players.size();
    }

    public static int sendKarmaInfo(CommandSource commandSource, PlayerEntity player) {
        AtomicInteger i = new AtomicInteger();
        player.getCapability(CapabilityKarma.KARMA).ifPresent(k -> {
            i.set(1);
            commandSource.func_197030_a((ITextComponent)new TranslationTextComponent("commands.karma.players_karma", new Object[]{player.func_145748_c_(), k.getKarma(), KarmaClass.fromKarma(k.getKarma()).getDisplayName()}), true);
        });
        return i.get();
    }
}

