/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.compat.jei.fluidcomposing;

import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.compat.jei.ThreeCoreJEIPlugin;
import net.threetag.threecore.item.recipe.FluidComposingRecipe;

public class FluidComposingCategory<T>
implements IRecipeCategory<FluidComposingRecipe> {
    private final String title = I18n.func_135052_a((String)"gui.jei.category.threecore.fluid_composing", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic tankOverlay;

    public FluidComposingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(ThreeCoreJEIPlugin.RECIPE_GUI_TEXTURE, 0, 86, 134, 62).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)TCBlocks.FLUID_COMPOSER.get()));
        this.arrow = guiHelper.drawableBuilder(ThreeCoreJEIPlugin.RECIPE_GUI_TEXTURE, 107, 0, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = guiHelper.createDrawable(ThreeCoreJEIPlugin.RECIPE_GUI_TEXTURE, 135, 87, 16, 60);
    }

    public ResourceLocation getUid() {
        return ThreeCoreJEIPlugin.FLUID_COMPOSING_CATEGORY;
    }

    public Class<? extends FluidComposingRecipe> getRecipeClass() {
        return FluidComposingRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(FluidComposingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setInputs(VanillaTypes.FLUID, Arrays.asList(recipe.getInputFluid().getFluids()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getResult(null));
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidComposingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = x + y * 3;
                itemStacks.init(index, true, 24 + x * 18, 0 + y * 18);
            }
        }
        fluidStacks.init(0, true, 1, 1, 16, 60, 5000, true, (IDrawable)this.tankOverlay);
        fluidStacks.init(1, false, 117, 1, 16, 60, 5000, true, (IDrawable)this.tankOverlay);
        itemStacks.set(ingredients);
        fluidStacks.set(ingredients);
    }

    public void draw(FluidComposingRecipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(87, 18);
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String s = I18n.func_135052_a((String)"threecore.util.energy_display", (Object[])new Object[]{recipe.getRequiredEnergy(), "FE"});
        int length = fontRenderer.func_78256_a(s);
        fontRenderer.func_211126_b(s, (float)(67 - length / 2), 55.0f, -8355712);
    }
}

