/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.compat.jei.grinding;

import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.block.TCBlocks;
import net.threetag.threecore.compat.jei.ThreeCoreJEIPlugin;
import net.threetag.threecore.item.recipe.GrindingRecipe;
import net.threetag.threecore.util.MathUtil;

public class GrindingCategory<T>
implements IRecipeCategory<GrindingRecipe> {
    protected static final int inputSlot = 0;
    protected static final int primaryOutputSlot = 1;
    protected static final int secondaryOutputSlot = 2;
    private final String title = I18n.func_135052_a((String)"gui.jei.category.threecore.grinding", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public GrindingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(ThreeCoreJEIPlugin.RECIPE_GUI_TEXTURE, 0, 0, 107, 26).addPadding(0, 10, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)TCBlocks.GRINDER.get()));
        this.arrow = guiHelper.drawableBuilder(ThreeCoreJEIPlugin.RECIPE_GUI_TEXTURE, 107, 0, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return ThreeCoreJEIPlugin.GRINDING_CATEGORY;
    }

    public Class<? extends GrindingRecipe> getRecipeClass() {
        return GrindingRecipe.class;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(GrindingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        if (recipe.getByproduct() == null || recipe.getByproduct().func_190926_b()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        } else {
            ingredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.func_77571_b(), recipe.getByproduct() == null ? ItemStack.field_190927_a : recipe.getByproduct()));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, GrindingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 4);
        itemStacks.init(1, false, 60, 4);
        itemStacks.init(2, false, 89, 4);
        itemStacks.set(ingredients);
        itemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex == 2 && !ingredient.func_190926_b()) {
                tooltip.add(MathUtil.round(recipe.getByproductChance() * 100.0f, 2) + "%");
            }
        });
    }

    public void draw(GrindingRecipe recipe, double mouseX, double mouseY) {
        this.arrow.draw(24, 4);
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        fontRenderer.func_211126_b(I18n.func_135052_a((String)"threecore.util.energy_display", (Object[])new Object[]{recipe.getRequiredEnergy(), "FE"}), 0.0f, 28.0f, -8355712);
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            String experienceString = I18n.func_135052_a((String)"gui.jei.category.threecore.grinding.experience", (Object[])new Object[]{Float.valueOf(experience)});
            int stringWidth = fontRenderer.func_78256_a(experienceString);
            fontRenderer.func_211126_b(experienceString, (float)(this.background.getWidth() - stringWidth), 28.0f, -8355712);
        }
    }
}

