/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.container;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.IRecipeContainer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.threetag.threecore.container.TCContainerTypes;
import net.threetag.threecore.item.recipe.PressingRecipe;
import net.threetag.threecore.tileentity.HydraulicPressTileEntity;

public class HydraulicPressContainer
extends RecipeBookContainer
implements IRecipeContainer {
    public final PlayerInventory inventoryPlayer;
    public final HydraulicPressTileEntity hydraulicPressTileEntity;
    private final IIntArray intArray;
    public RecipeWrapper recipeWrapper;
    protected final World world;

    public HydraulicPressContainer(int id, PlayerInventory inventoryPlayer) {
        this(id, inventoryPlayer, new HydraulicPressTileEntity(), (IIntArray)new IntArray(4));
    }

    public HydraulicPressContainer(int id, PlayerInventory inventoryPlayer, HydraulicPressTileEntity hydraulicPressTileEntity, IIntArray intArray) {
        super((ContainerType)TCContainerTypes.HYDRAULIC_PRESS.get(), id);
        this.inventoryPlayer = inventoryPlayer;
        this.hydraulicPressTileEntity = hydraulicPressTileEntity;
        this.recipeWrapper = this.hydraulicPressTileEntity.recipeWrapper;
        this.world = inventoryPlayer.field_70458_d.field_70170_p;
        this.hydraulicPressTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(i -> HydraulicPressContainer.func_216962_a((IInventory)new RecipeWrapper((IItemHandlerModifiable)i), (int)4));
        HydraulicPressContainer.func_216959_a((IIntArray)intArray, (int)4);
        this.intArray = intArray;
        this.func_216961_a(this.intArray);
        this.hydraulicPressTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 0, 8, 61));
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 1, 40, 39));
            this.func_75146_a((Slot)new SlotItemHandler(itemHandler, 2, 72, 39));
            this.func_75146_a((Slot)new HydraulicPressResultSlot(inventoryPlayer.field_70458_d, (TileEntity)hydraulicPressTileEntity, (IItemHandler)itemHandler, 3, 134, 39));
        });
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i2 * 9 + 9, 8 + j * 18, 92 + i2 * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, k, 8 + k * 18, 150));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.hydraulicPressTileEntity.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 3) {
                if (!this.func_75135_a(itemstack1, 4, 40, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index > 2 ? (itemstack1.getCapability(CapabilityEnergy.ENERGY).isPresent() ? !this.func_75135_a(itemstack1, 0, 1, false) : (this.canWork(itemstack1) ? !this.func_75135_a(itemstack1, 1, 2, false) : (this.isCast(itemstack1) ? !this.func_75135_a(itemstack1, 2, 3, false) : (index >= 4 && index < 31 ? !this.func_75135_a(itemstack1, 31, 40, false) : index >= 31 && index < 40 && !this.func_75135_a(itemstack1, 4, 31, false))))) : !this.func_75135_a(itemstack1, 4, 40, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }

    private boolean canWork(ItemStack stack) {
        AtomicBoolean b = new AtomicBoolean(false);
        this.world.func_199532_z().func_215366_a(PressingRecipe.RECIPE_TYPE).forEach((id, recipe) -> {
            if (((Ingredient)recipe.func_192400_c().get(0)).test(stack)) {
                b.set(true);
            }
        });
        return b.get();
    }

    private boolean isCast(ItemStack stack) {
        AtomicBoolean b = new AtomicBoolean(false);
        this.world.func_199532_z().func_215366_a(PressingRecipe.RECIPE_TYPE).forEach((id, recipe) -> {
            if (((Ingredient)recipe.func_192400_c().get(1)).test(stack)) {
                b.set(true);
            }
        });
        return b.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int width) {
        int progress = this.intArray.func_221476_a(0);
        int maxProgress = this.intArray.func_221476_a(1);
        return maxProgress != 0 && progress != 0 ? progress * width / maxProgress : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getEnergyPercentage() {
        return (float)this.intArray.func_221476_a(2) / (float)this.intArray.func_221476_a(3);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getEnergyStored() {
        return this.intArray.func_221476_a(2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxEnergyStored() {
        return this.intArray.func_221476_a(3);
    }

    public CraftResultInventory getCraftResult() {
        return null;
    }

    public CraftingInventory getCraftMatrix() {
        return null;
    }

    public void func_201771_a(RecipeItemHelper recipeItemHelper) {
        if (this.hydraulicPressTileEntity instanceof IRecipeHelperPopulator) {
            ((IRecipeHelperPopulator)this.hydraulicPressTileEntity).func_194018_a(recipeItemHelper);
        }
    }

    public void func_201768_e() {
        this.hydraulicPressTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            if (itemHandler instanceof IItemHandlerModifiable) {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ((IItemHandlerModifiable)itemHandler).setStackInSlot(i, ItemStack.field_190927_a);
                }
            }
        });
    }

    public boolean func_201769_a(IRecipe recipe) {
        return recipe.func_77569_a((IInventory)this.recipeWrapper, this.inventoryPlayer.field_70458_d.field_70170_p);
    }

    public int func_201767_f() {
        return 1;
    }

    public int func_201770_g() {
        return 1;
    }

    public int func_201772_h() {
        return 1;
    }

    public int func_203721_h() {
        return 3;
    }

    public static class HydraulicPressResultSlot
    extends SlotItemHandler {
        private final PlayerEntity player;
        private final TileEntity tileEntity;
        private int removeCount;

        public HydraulicPressResultSlot(PlayerEntity player, TileEntity tileEntity, IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.player = player;
            this.tileEntity = tileEntity;
        }

        @Nonnull
        public ItemStack func_75209_a(int amount) {
            if (this.func_75216_d()) {
                this.removeCount += Math.min(amount, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(amount);
        }

        public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
            this.func_75208_c(stack);
            super.func_190901_a(thePlayer, stack);
            return stack;
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.func_75208_c(stack);
        }

        protected void func_75208_c(ItemStack stack) {
            stack.func_77980_a(this.player.field_70170_p, this.player, this.removeCount);
            if (!this.player.field_70170_p.field_72995_K && this.field_75224_c instanceof HydraulicPressTileEntity) {
                ((HydraulicPressTileEntity)this.field_75224_c).unlockRecipes(this.player);
            }
            this.removeCount = 0;
        }
    }
}

