/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.data.ExtRecipeOutput;
import net.threetag.threecore.item.recipe.AbstractConstructionTableRecipe;

public class ConstructionTableRecipeBuilder {
    private final IRecipeSerializer<? extends AbstractConstructionTableRecipe> recipeSerializer;
    private final ExtRecipeOutput result;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
    private Ingredient toolIngredient;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private String group;
    private boolean consumesTool;

    public ConstructionTableRecipeBuilder(IRecipeSerializer<? extends AbstractConstructionTableRecipe> recipeSerializer, IItemProvider itemProvider, int amount) {
        this.recipeSerializer = recipeSerializer;
        this.result = new ExtRecipeOutput(new ItemStack(itemProvider, amount));
    }

    public static ConstructionTableRecipeBuilder recipe(IRecipeSerializer<? extends AbstractConstructionTableRecipe> recipeSerializer, IItemProvider itemProvider) {
        return ConstructionTableRecipeBuilder.recipe(recipeSerializer, itemProvider, 1);
    }

    public static ConstructionTableRecipeBuilder recipe(IRecipeSerializer<? extends AbstractConstructionTableRecipe> recipeSerializer, IItemProvider itemProvider, int amount) {
        return new ConstructionTableRecipeBuilder(recipeSerializer, itemProvider, amount);
    }

    public ConstructionTableRecipeBuilder key(Character character, Tag<Item> tag) {
        return this.key(character, Ingredient.func_199805_a(tag));
    }

    public ConstructionTableRecipeBuilder key(Character character, IItemProvider itemProvider) {
        return this.key(character, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}));
    }

    public ConstructionTableRecipeBuilder key(Character character, Ingredient ingredient) {
        if (this.key.containsKey(character)) {
            throw new IllegalArgumentException("Symbol '" + character + "' is already defined!");
        }
        if (character.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(character, ingredient);
        return this;
    }

    public ConstructionTableRecipeBuilder enableToolConsuming() {
        this.consumesTool = true;
        return this;
    }

    public ConstructionTableRecipeBuilder patternLine(String patternLine) {
        this.pattern.add(patternLine);
        return this;
    }

    public ConstructionTableRecipeBuilder addCriterion(String name, ICriterionInstance criterionInstance) {
        this.advancementBuilder.func_200275_a(name, criterionInstance);
        return this;
    }

    public ConstructionTableRecipeBuilder setToolIngredient(Ingredient ingredient) {
        this.toolIngredient = ingredient;
        return this;
    }

    public ConstructionTableRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result.getId());
    }

    public void build(Consumer<IFinishedRecipe> consumer, String name) {
        ResourceLocation id = this.result.getId();
        if (new ResourceLocation(name).equals((Object)id)) {
            throw new IllegalStateException("Construction Table Recipe " + name + " should remove its 'save' argument");
        }
        this.build(consumer, new ResourceLocation(name));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation location) {
        this.validate(location);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(location)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)location)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(this.recipeSerializer, location, this.result, this.group == null ? "" : this.group, this.pattern, this.key, this.toolIngredient, this.advancementBuilder, new ResourceLocation(location.func_110624_b(), "recipes/" + this.result.getGroup() + "/" + location.func_110623_a()), this.consumesTool));
    }

    private void validate(ResourceLocation location) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for construction table recipe " + location + "!");
        }
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + location);
        }
    }

    public class Result
    implements IFinishedRecipe {
        private final IRecipeSerializer<? extends AbstractConstructionTableRecipe> recipeSerializer;
        private final ResourceLocation id;
        private final ExtRecipeOutput result;
        private final String group;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final Ingredient toolIngredient;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;
        private final boolean consumesTool;

        public Result(IRecipeSerializer<? extends AbstractConstructionTableRecipe> recipeSerializer, ResourceLocation id, ExtRecipeOutput result, String group, List<String> pattern, Map<Character, Ingredient> key, Ingredient toolIngredient, Advancement.Builder advancementBuilder, ResourceLocation advancementId, boolean consumesTool) {
            this.recipeSerializer = recipeSerializer;
            this.id = id;
            this.result = result;
            this.group = group;
            this.pattern = pattern;
            this.key = key;
            this.toolIngredient = toolIngredient;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
            this.consumesTool = consumesTool;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            JsonArray patternArray = new JsonArray();
            for (String line : this.pattern) {
                patternArray.add(line);
            }
            json.add("pattern", (JsonElement)patternArray);
            JsonObject keyJson = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                keyJson.add(String.valueOf(entry.getKey()), entry.getValue().func_200304_c());
            }
            json.add("key", (JsonElement)keyJson);
            if (this.toolIngredient != null) {
                json.add("tool", this.toolIngredient.func_200304_c());
            }
            json.addProperty("consumes_tool", Boolean.valueOf(this.consumesTool));
            json.add("result", (JsonElement)this.result.serialize());
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.recipeSerializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

