/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.data;

import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.ability.AbilityType;

public abstract class ExtendedLanguageProvider
extends LanguageProvider {
    private final String modid;

    public ExtendedLanguageProvider(DataGenerator gen, String modid, String locale) {
        super(gen, modid, locale);
        this.modid = modid;
    }

    protected String getModId() {
        return this.modid;
    }

    protected void addSubtitle(String key, String name) {
        this.add("subtitles." + this.getModId() + "." + key, name);
    }

    protected void addAbilityType(Supplier<? extends AbilityType> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(AbilityType key, String name) {
        this.add(Util.func_200697_a((String)"ability", (ResourceLocation)AbilityType.REGISTRY.getKey((IForgeRegistryEntry)key)), name);
    }

    protected void addFluid(Supplier<? extends Fluid> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(Fluid key, String name) {
        this.add(Util.func_200697_a((String)"fluid", (ResourceLocation)ForgeRegistries.FLUIDS.getKey((IForgeRegistryEntry)key)), name);
    }

    protected void addContainerType(Supplier<? extends ContainerType> key, String name) {
        this.add(key.get(), name);
    }

    protected void add(ContainerType key, String name) {
        this.add(Util.func_200697_a((String)"container", (ResourceLocation)ForgeRegistries.CONTAINERS.getKey((IForgeRegistryEntry)key)), name);
    }
}

