/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.fluids.FluidStack;
import net.threetag.threecore.fluid.FluidIngredient;
import net.threetag.threecore.item.recipe.TCRecipeSerializers;
import net.threetag.threecore.util.TCFluidUtil;

public class FluidComposingRecipeBuilder {
    private String group;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private FluidIngredient inputFluid;
    private FluidStack result;
    private int energy = 0;
    private List<ICondition> conditions = new ArrayList<ICondition>();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();

    public FluidComposingRecipeBuilder(FluidStack result) {
        this.result = result;
    }

    public FluidComposingRecipeBuilder addIngredient(Tag<Item> tag) {
        return this.addIngredient(Ingredient.func_199805_a(tag));
    }

    public FluidComposingRecipeBuilder addIngredient(IItemProvider itemProvider) {
        return this.addIngredient(itemProvider, 1);
    }

    public FluidComposingRecipeBuilder addIngredient(IItemProvider itemProvider, int count) {
        for (int i = 0; i < count; ++i) {
            this.addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{itemProvider}));
        }
        return this;
    }

    public FluidComposingRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public FluidComposingRecipeBuilder addIngredient(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public FluidComposingRecipeBuilder setInputFluid(FluidIngredient fluid) {
        this.inputFluid = fluid;
        return this;
    }

    public FluidComposingRecipeBuilder setEnergy(int energy) {
        this.energy = energy;
        return this;
    }

    public FluidComposingRecipeBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public FluidComposingRecipeBuilder addCriterion(String key, ICriterionInstance criterionInstance) {
        this.advancementBuilder.func_200275_a(key, criterionInstance);
        return this;
    }

    public FluidComposingRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    private void validate(ResourceLocation resourceLocation) {
        if (this.inputFluid == null) {
            throw new IllegalStateException("No input specified for recipe " + resourceLocation);
        }
        if (this.ingredients.size() <= 0) {
            throw new IllegalStateException("Not enough ingredients for recipe " + resourceLocation);
        }
        if (this.advancementBuilder.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
        if (this.energy <= 0) {
            throw new IllegalStateException("Energy for " + resourceLocation + " must be greater than 0!");
        }
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.result.getFluid().getRegistryName());
    }

    public void build(Consumer<IFinishedRecipe> consumer, String name) {
        ResourceLocation resourceLocation = this.result.getFluid().getRegistryName();
        if (new ResourceLocation(name).equals((Object)resourceLocation)) {
            throw new IllegalStateException("Fluid Composing Recipe " + name + " should remove its 'save' argument");
        }
        this.build(consumer, new ResourceLocation(name));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation name) {
        this.validate(name);
        this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(name)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)name)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(name, this.group == null ? "" : this.group, this.ingredients, this.inputFluid, this.result, this.energy, this.conditions, this.advancementBuilder, new ResourceLocation(name.func_110624_b(), "recipes/fluids/" + name.func_110623_a())));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final List<Ingredient> ingredients;
        private final FluidIngredient inputFluid;
        private final FluidStack result;
        private final int energy;
        private final List<ICondition> conditions;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, String group, List<Ingredient> ingredients, FluidIngredient inputFluid, FluidStack result, int energy, List<ICondition> conditions, Advancement.Builder advancementBuilder, ResourceLocation advancementId) {
            this.id = id;
            this.group = group;
            this.ingredients = ingredients;
            this.inputFluid = inputFluid;
            this.result = result;
            this.energy = energy;
            this.conditions = conditions;
            this.advancementBuilder = advancementBuilder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            if (this.conditions != null && !this.conditions.isEmpty()) {
                JsonArray conds = new JsonArray();
                for (ICondition c : this.conditions) {
                    conds.add((JsonElement)CraftingHelper.serialize((ICondition)c));
                }
                jsonObject.add("conditions", (JsonElement)conds);
            }
            jsonObject.add("output", (JsonElement)TCFluidUtil.serializeFluidStack(this.result));
            JsonArray array = new JsonArray();
            for (Ingredient ingredient : this.ingredients) {
                array.add(ingredient.func_200304_c());
            }
            jsonObject.add("ingredients", (JsonElement)array);
            if (this.inputFluid.getTag() == null) {
                if (this.inputFluid.getFluids().length == 1) {
                    jsonObject.add("fluid_input", (JsonElement)TCFluidUtil.serializeFluidStack(this.inputFluid.getFluids()[0]));
                } else {
                    JsonArray fluids = new JsonArray();
                    for (FluidStack fluidStack : this.inputFluid.getFluids()) {
                        fluids.add((JsonElement)TCFluidUtil.serializeFluidStack(fluidStack));
                    }
                    jsonObject.add("fluid_input", (JsonElement)fluids);
                }
            } else {
                JsonObject fluidInput = new JsonObject();
                fluidInput.addProperty("tag", this.inputFluid.getTag().func_199886_b().toString());
                fluidInput.addProperty("amount", (Number)this.inputFluid.getFluids()[0].getAmount());
                jsonObject.add("fluid_input", (JsonElement)fluidInput);
            }
            jsonObject.addProperty("energy", (Number)this.energy);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)TCRecipeSerializers.FLUID_COMPOSING.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.advancementBuilder.func_200273_b();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.advancementId;
        }
    }
}

