/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.entity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.entity.TCEntityTypes;
import net.threetag.threecore.scripts.events.ProjectileTickScriptEvent;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class ProjectileEntity
extends ThrowableEntity
implements IRendersAsItem,
IEntityAdditionalSpawnData {
    public float damage = 3.0f;
    public float gravityVelocity = 0.03f;
    public boolean dieOnBlockHit = true;
    public boolean dieOnEntityHit = true;
    public boolean particles = true;
    public ProjectileRenderInfo renderInfo = new ProjectileRenderInfo(new ItemStack((IItemProvider)Blocks.field_150348_b));

    public ProjectileEntity(EntityType<? extends ProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public ProjectileEntity(World world, double x, double y, double z) {
        super((EntityType)TCEntityTypes.PROJECTILE.get(), x, y, z, world);
    }

    public ProjectileEntity(World world, LivingEntity livingEntity) {
        super((EntityType)TCEntityTypes.PROJECTILE.get(), livingEntity, world);
    }

    protected void func_70088_a() {
    }

    protected float func_70185_h() {
        return this.gravityVelocity;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.damage);
            if (this.dieOnEntityHit && !this.field_70170_p.field_72995_K) {
                if (this.particles) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                }
                this.func_70106_y();
            }
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK && this.dieOnBlockHit && !this.field_70170_p.field_72995_K) {
            if (this.particles) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            }
            this.func_70106_y();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private IParticleData makeParticle() {
        ItemStack stack = this.getRenderedItem();
        return stack.func_190926_b() ? ParticleTypes.field_197613_f : new ItemParticleData(ParticleTypes.field_197591_B, stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte state) {
        if (state == 3) {
            IParticleData particle = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a(particle, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_70071_h_() {
        ProjectileTickScriptEvent event = new ProjectileTickScriptEvent((Entity)this);
        if (event.fire(null)) {
            return;
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.renderInfo.isParticles()) {
            Random random = new Random();
            float sX = (random.nextFloat() - 0.5f) * this.renderInfo.getParticleSpread();
            float sY = (random.nextFloat() - 0.5f) * this.renderInfo.getParticleSpread();
            float sZ = (random.nextFloat() - 0.5f) * this.renderInfo.getParticleSpread();
            try {
                this.field_70170_p.func_195594_a(this.renderInfo.getParticleType().func_197571_g().func_197544_b(this.renderInfo.getParticleType(), new StringReader(this.renderInfo.particleOptions)), this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)sX, (double)sY, (double)sZ);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Damage", this.damage);
        compound.func_74776_a("GravityVelocity", this.gravityVelocity);
        compound.func_74757_a("DieOnEntityHit", this.dieOnEntityHit);
        compound.func_74757_a("DieOnBlockHit", this.dieOnBlockHit);
        compound.func_74757_a("Particles", this.particles);
        compound.func_218657_a("RenderInfo", (INBT)this.renderInfo.serializeNBT());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Damage", 99)) {
            this.damage = compound.func_74762_e("Damage");
        }
        if (compound.func_150297_b("GravityVelocity", 99)) {
            this.gravityVelocity = compound.func_74762_e("gravityVelocity");
        }
        if (compound.func_74764_b("DieOnEntityHit")) {
            this.dieOnEntityHit = compound.func_74767_n("DieOnEntityHit");
        }
        if (compound.func_74764_b("DieOnBlockHit")) {
            this.dieOnBlockHit = compound.func_74767_n("DieOnBlockHit");
        }
        if (compound.func_74764_b("Particles")) {
            this.particles = compound.func_74767_n("Particles");
        }
        this.renderInfo = new ProjectileRenderInfo(compound.func_74775_l("RenderInfo"));
    }

    public ItemStack getRenderedItem() {
        return this.renderInfo.isItem() ? this.renderInfo.getStack() : ItemStack.field_190927_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_184543_l() {
        return this.getRenderedItem();
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150786_a(this.renderInfo.serializeNBT());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        CompoundNBT nbt = additionalData.func_150793_b();
        this.renderInfo = new ProjectileRenderInfo(nbt);
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static class ProjectileRenderInfo
    implements INBTSerializable<CompoundNBT> {
        private int type;
        private ItemStack stack;
        private ResourceLocation modelLayer;
        private Color color;
        private ParticleType<?> particleType;
        private float particleSpread;
        private String particleOptions;

        public ProjectileRenderInfo(ItemStack stack) {
            this.type = 1;
            this.stack = stack;
        }

        public ProjectileRenderInfo(ResourceLocation modelLayer) {
            this.type = 2;
            this.modelLayer = modelLayer;
        }

        public ProjectileRenderInfo(Color energyColor) {
            this.type = 3;
            this.color = energyColor;
        }

        public ProjectileRenderInfo(ParticleType particleType, float particleSpread) {
            this.type = 4;
            this.particleType = particleType;
            this.particleSpread = particleSpread;
        }

        public ProjectileRenderInfo(CompoundNBT nbt) {
            this.deserializeNBT(nbt);
        }

        public boolean isItem() {
            return this.type == 1 && this.stack != null;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public boolean isModelLayer() {
            return this.type == 2 && this.modelLayer != null;
        }

        public ResourceLocation getModelLayer() {
            return this.modelLayer;
        }

        public boolean isEnergy() {
            return this.type == 3;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isParticles() {
            return this.type == 4 && this.particleType != null;
        }

        public ParticleType getParticleType() {
            return this.particleType;
        }

        public float getParticleSpread() {
            return this.particleSpread;
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("Type", this.type);
            if (this.isItem()) {
                nbt.func_218657_a("Item", (INBT)this.stack.serializeNBT());
            } else if (this.getModelLayer() != null) {
                nbt.func_74778_a("ModelLayer", this.modelLayer.toString());
            } else if (this.isEnergy()) {
                ListNBT listNBT = new ListNBT();
                listNBT.add((Object)new IntNBT(this.color.getRed()));
                listNBT.add((Object)new IntNBT(this.color.getGreen()));
                listNBT.add((Object)new IntNBT(this.color.getBlue()));
                nbt.func_218657_a("EnergyColor", (INBT)listNBT);
            } else if (this.isParticles()) {
                nbt.func_74778_a("ParticleType", ForgeRegistries.PARTICLE_TYPES.getKey(this.particleType).toString());
                nbt.func_74776_a("ParticleSpread", this.particleSpread);
                nbt.func_74778_a("ParticleOptions", this.particleOptions);
            }
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            if (nbt.func_74764_b("Type")) {
                this.type = nbt.func_74762_e("Type");
                if (this.type == 1) {
                    this.stack = nbt.func_74781_a("Item") instanceof CompoundNBT ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item")) : new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("Item"))));
                } else if (this.type == 2) {
                    this.modelLayer = new ResourceLocation(nbt.func_74779_i("ModelLayer"));
                } else if (this.type == 3) {
                    ListNBT listNBT = nbt.func_150295_c("EnergyColor", 3);
                    this.color = nbt.func_74764_b("EnergyColor") && listNBT.size() == 3 ? new Color(listNBT.func_186858_c(0), listNBT.func_186858_c(1), listNBT.func_186858_c(2)) : Color.RED;
                } else if (this.type == 4) {
                    this.particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(nbt.func_74779_i("ParticleType")));
                    this.particleSpread = nbt.func_74760_g("ParticleSpread");
                    this.particleOptions = nbt.func_74779_i("ParticleOptions");
                }
            } else if (nbt.func_74764_b("Item")) {
                this.type = 1;
                this.stack = nbt.func_74781_a("Item") instanceof CompoundNBT ? ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item")) : new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("Item"))));
            } else if (nbt.func_74764_b("ModelLayer")) {
                this.type = 2;
                this.modelLayer = new ResourceLocation(nbt.func_74779_i("ModelLayer"));
            } else if (nbt.func_74764_b("EnergyColor")) {
                this.type = 3;
                ListNBT listNBT = nbt.func_150295_c("EnergyColor", 3);
                this.color = listNBT.size() == 3 ? new Color(listNBT.func_186858_c(0), listNBT.func_186858_c(1), listNBT.func_186858_c(2)) : Color.RED;
            } else if (nbt.func_74764_b("ParticleType")) {
                this.type = 4;
                this.particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(nbt.func_74779_i("ParticleType")));
                this.particleSpread = nbt.func_74760_g("ParticleSpread");
                this.particleOptions = nbt.func_74779_i("ParticleOptions");
            }
        }
    }
}

