/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.entity.armorstand;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.Rotations;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.util.TCJsonUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ArmorStandPoseManager {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final File DIRECTORY = new File("config/threecore/armorstandposes");
    public static Map<String, ArmorStandPose> POSES = Maps.newHashMap();

    public static int init() {
        DIRECTORY.mkdirs();
        POSES.clear();
        for (File file : FileUtils.listFiles((File)DIRECTORY, (String[])new String[]{"json"}, (boolean)true)) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                JsonObject json = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                String name = FilenameUtils.getBaseName((String)file.getName());
                try {
                    ArmorStandPose pose = ArmorStandPoseManager.parse(json);
                    ArmorStandPoseManager.register(name, pose);
                }
                catch (Exception e) {
                    ThreeCore.LOGGER.error("Parsing error loading armor stand pose {}", (Object)name, (Object)e);
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        ThreeCore.LOGGER.info("Loaded {} armor stand poses from files", (Object)POSES.size());
        if (POSES.size() == 0) {
            ThreeCore.LOGGER.info("Generating default armor stand poses...");
            ArmorStandPoseManager.generateFile("dab", new ArmorStandPose(new Rotations(45.0f, 0.0f, 0.0f), ArmorStandPose.EMPTY_ROTATION, new Rotations(90.0f, 310.0f, 15.0f), new Rotations(90.0f, 220.0f, 0.0f), ArmorStandPose.EMPTY_ROTATION, ArmorStandPose.EMPTY_ROTATION));
            ArmorStandPoseManager.generateFile("zombie", new ArmorStandPose(ArmorStandPose.EMPTY_ROTATION, ArmorStandPose.EMPTY_ROTATION, new Rotations(270.0f, 0.0f, 0.0f), new Rotations(270.0f, 0.0f, 0.0f), ArmorStandPose.EMPTY_ROTATION, ArmorStandPose.EMPTY_ROTATION));
            ArmorStandPoseManager.generateFile("t-pose", new ArmorStandPose(ArmorStandPose.EMPTY_ROTATION, ArmorStandPose.EMPTY_ROTATION, new Rotations(0.0f, 0.0f, 90.0f), new Rotations(0.0f, 0.0f, 270.0f), ArmorStandPose.EMPTY_ROTATION, ArmorStandPose.EMPTY_ROTATION));
            ArmorStandPoseManager.generateFile("cheering", new ArmorStandPose(ArmorStandPose.EMPTY_ROTATION, ArmorStandPose.EMPTY_ROTATION, new Rotations(0.0f, 0.0f, 150.0f), new Rotations(0.0f, 0.0f, 210.0f), ArmorStandPose.EMPTY_ROTATION, ArmorStandPose.EMPTY_ROTATION));
        }
        return POSES.size();
    }

    private static void generateFile(String name, ArmorStandPose pose) {
        try (FileWriter w = new FileWriter(new File(DIRECTORY, name + ".json"));){
            GSON.toJson((JsonElement)pose.serialize(), (Appendable)w);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArmorStandPoseManager.register(name, pose);
    }

    public static ArmorStandPose parse(JsonObject json) {
        Rotations head = ArmorStandPoseManager.makeRotations(TCJsonUtil.getFloatArray(json, 3, "head", 0.0f, 0.0f, 0.0f));
        Rotations body = ArmorStandPoseManager.makeRotations(TCJsonUtil.getFloatArray(json, 3, "body", 0.0f, 0.0f, 0.0f));
        Rotations rightArm = ArmorStandPoseManager.makeRotations(TCJsonUtil.getFloatArray(json, 3, "right_arm", 0.0f, 0.0f, 0.0f));
        Rotations leftArm = ArmorStandPoseManager.makeRotations(TCJsonUtil.getFloatArray(json, 3, "left_arm", 0.0f, 0.0f, 0.0f));
        Rotations rightLeg = ArmorStandPoseManager.makeRotations(TCJsonUtil.getFloatArray(json, 3, "right_leg", 0.0f, 0.0f, 0.0f));
        Rotations leftLeg = ArmorStandPoseManager.makeRotations(TCJsonUtil.getFloatArray(json, 3, "left_leg", 0.0f, 0.0f, 0.0f));
        return new ArmorStandPose(head, body, rightArm, leftArm, rightLeg, leftLeg);
    }

    public static void register(String name, ArmorStandPose pose) {
        POSES.put(name, pose);
    }

    private static Rotations makeRotations(float[] floats) {
        return new Rotations(floats[0], floats[1], floats[2]);
    }

    public static class ArmorStandPose {
        public static final Rotations EMPTY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
        public final Rotations head;
        public final Rotations body;
        public final Rotations rightArm;
        public final Rotations leftArm;
        public final Rotations rightLeg;
        public final Rotations leftLeg;

        public ArmorStandPose(Rotations head, Rotations body, Rotations rightArm, Rotations leftArm, Rotations rightLeg, Rotations leftLeg) {
            this.head = head;
            this.body = body;
            this.rightArm = rightArm;
            this.leftArm = leftArm;
            this.rightLeg = rightLeg;
            this.leftLeg = leftLeg;
        }

        public void set(ArmorStandEntity armorStandEntity) {
            armorStandEntity.func_175415_a(this.head);
            armorStandEntity.func_175424_b(this.body);
            armorStandEntity.func_175428_d(this.rightArm);
            armorStandEntity.func_175405_c(this.leftArm);
            armorStandEntity.func_175427_f(this.rightLeg);
            armorStandEntity.func_175417_e(this.leftLeg);
        }

        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("head", (JsonElement)ArmorStandPose.serializeRotation(this.head));
            jsonObject.add("body", (JsonElement)ArmorStandPose.serializeRotation(this.body));
            jsonObject.add("right_arm", (JsonElement)ArmorStandPose.serializeRotation(this.rightArm));
            jsonObject.add("left_arm", (JsonElement)ArmorStandPose.serializeRotation(this.leftArm));
            jsonObject.add("right_leg", (JsonElement)ArmorStandPose.serializeRotation(this.rightLeg));
            jsonObject.add("left_leg", (JsonElement)ArmorStandPose.serializeRotation(this.leftLeg));
            return jsonObject;
        }

        public static JsonArray serializeRotation(Rotations rotations) {
            JsonArray jsonArray = new JsonArray();
            jsonArray.add((Number)Float.valueOf(rotations.func_179415_b()));
            jsonArray.add((Number)Float.valueOf(rotations.func_179416_c()));
            jsonArray.add((Number)Float.valueOf(rotations.func_179413_d()));
            return jsonArray;
        }
    }
}

