/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.fluid;

import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.threetag.threecore.util.TCFluidUtil;

public class FluidTankExt
extends FluidTank {
    private Consumer<SoundEvent> soundHandler;
    private Consumer<FluidStack> changedCallback;

    public FluidTankExt(int capacity) {
        super(capacity);
    }

    public FluidTankExt(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    public FluidTankExt setSoundHandler(Consumer<SoundEvent> soundHandler) {
        this.soundHandler = soundHandler;
        return this;
    }

    public FluidTankExt setCallback(Consumer<FluidStack> callback) {
        this.changedCallback = callback;
        return this;
    }

    protected void onContentsChanged() {
        if (this.changedCallback != null) {
            this.changedCallback.accept(this.getFluid());
        }
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack stack = super.drain(maxDrain, action);
        if (!stack.isEmpty() && action.execute()) {
            this.onContentsChanged();
            if (this.soundHandler != null) {
                this.soundHandler.accept(TCFluidUtil.getSound(stack, false));
            }
        }
        return stack;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int fill = super.fill(resource, action);
        if (fill > 0 && action.execute()) {
            this.onContentsChanged();
            if (this.soundHandler != null) {
                this.soundHandler.accept(TCFluidUtil.getSound(resource, true));
            }
        }
        return fill;
    }
}

