/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.threetag.threecore.util.energy.EnergyStorageItem;
import net.threetag.threecore.util.energy.EnergyUtil;
import net.threetag.threecore.util.energy.IEnergyConfig;

public class CapacitorItem
extends Item {
    private Supplier<Integer> capacity;
    private Supplier<Integer> maxTransfer;

    public CapacitorItem(Item.Properties properties, int capacity, int maxTransfer) {
        super(properties);
        this.capacity = () -> capacity;
        this.maxTransfer = () -> maxTransfer;
    }

    public CapacitorItem(Item.Properties properties, IEnergyConfig energyConfig) {
        super(properties);
        this.capacity = energyConfig::getCapacity;
        this.maxTransfer = energyConfig::getPower;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> list.add(EnergyUtil.getFormattedEnergy(e).func_211708_a(TextFormatting.GRAY)));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack stack = new ItemStack((IItemProvider)this);
            stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> stack.func_196082_o().func_74768_a("Energy", e.getMaxEnergyStored()));
            items.add((Object)stack);
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyItemCapabilityProvider(stack, this.capacity.get(), this.maxTransfer.get());
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        AtomicReference<Double> d = new AtomicReference<Double>(1.0);
        stack.getCapability(CapabilityEnergy.ENERGY).ifPresent(e -> d.set(1.0 - (double)e.getEnergyStored() / (double)e.getMaxEnergyStored()));
        return d.get();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public static class EnergyItemCapabilityProvider
    implements ICapabilityProvider {
        final ItemStack stack;
        final IEnergyStorage energyStorage;
        final LazyOptional<IEnergyStorage> lazyOptional;

        public EnergyItemCapabilityProvider(ItemStack stack, int capacity, int maxReceive, int maxExtract) {
            this.stack = stack;
            this.energyStorage = new EnergyStorageItem(stack, capacity, maxReceive, maxExtract);
            this.lazyOptional = LazyOptional.of(() -> this.energyStorage);
        }

        public EnergyItemCapabilityProvider(ItemStack stack, int capacity, int maxTransfer) {
            this(stack, capacity, maxTransfer, maxTransfer);
        }

        public EnergyItemCapabilityProvider(ItemStack stack, int capacity) {
            this(stack, capacity, capacity, capacity);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == CapabilityEnergy.ENERGY ? this.lazyOptional : LazyOptional.empty();
        }
    }
}

