/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.item.SimpleItemGroup;
import net.threetag.threecore.item.TCItems;

public class ItemGroupRegistry {
    private static Map<String, ItemGroup> ITEM_GROUPS = new HashMap<String, ItemGroup>();
    public static final String TECHNOLOGY = "technology";
    public static final String SUITS_AND_ARMOR = "suits_and_armor";

    public static ItemGroup getItemGroup(String name) {
        if (name.equalsIgnoreCase("blocks")) {
            return ItemGroup.field_78030_b;
        }
        if (name.equalsIgnoreCase("decoration")) {
            return ItemGroup.field_78031_c;
        }
        if (name.equalsIgnoreCase("redstone")) {
            return ItemGroup.field_78028_d;
        }
        if (name.equalsIgnoreCase("transportation")) {
            return ItemGroup.field_78029_e;
        }
        if (name.equalsIgnoreCase("misc")) {
            return ItemGroup.field_78026_f;
        }
        if (name.equalsIgnoreCase("food")) {
            return ItemGroup.field_78039_h;
        }
        if (name.equalsIgnoreCase("tools")) {
            return ItemGroup.field_78040_i;
        }
        if (name.equalsIgnoreCase("combat")) {
            return ItemGroup.field_78037_j;
        }
        if (name.equalsIgnoreCase("brewing")) {
            return ItemGroup.field_78038_k;
        }
        return ITEM_GROUPS.get(name.toLowerCase());
    }

    public static ItemGroup addItemGroup(String name, ItemStack stack) {
        return ItemGroupRegistry.addItemGroup(name, () -> stack);
    }

    public static ItemGroup addItemGroup(String name, Supplier<ItemStack> stackSupplier) {
        return ItemGroupRegistry.addItemGroup(name, new SimpleItemGroup(name, stackSupplier));
    }

    public static ItemGroup addItemGroup(String name, ItemGroup itemGroup) {
        ITEM_GROUPS.put(name, itemGroup);
        return itemGroup;
    }

    public static ItemGroup getOrCreateItemGroup(String name, ItemStack stack) {
        return ItemGroupRegistry.getOrCreateItemGroup(name, () -> stack);
    }

    public static ItemGroup getOrCreateItemGroup(String name, Supplier<ItemStack> stackSupplier) {
        ItemGroup itemGroup = ItemGroupRegistry.getItemGroup(name);
        if (itemGroup != null) {
            return itemGroup;
        }
        return ItemGroupRegistry.addItemGroup(name, stackSupplier);
    }

    public static ItemGroup getTechnologyGroup() {
        return ItemGroupRegistry.getItemGroup(TECHNOLOGY);
    }

    public static ItemGroup getSuitsAndArmorGroup() {
        return ItemGroupRegistry.getItemGroup(SUITS_AND_ARMOR);
    }

    static {
        ItemGroupRegistry.getOrCreateItemGroup(TECHNOLOGY, () -> new ItemStack((IItemProvider)TCItems.CIRCUIT.get()));
        ItemGroupRegistry.addItemGroup(SUITS_AND_ARMOR, new SuitsAndArmorItemGroup(SUITS_AND_ARMOR));
    }

    public static class SuitsAndArmorItemGroup
    extends ItemGroup {
        public SuitsAndArmorItemGroup(String label) {
            super(label);
        }

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)Items.field_151027_R);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_78018_a(NonNullList<ItemStack> items) {
            for (Item item : ForgeRegistries.ITEMS) {
                item.func_150895_a((ItemGroup)this, items);
                if (!item.getRegistryName().func_110624_b().equalsIgnoreCase("minecraft") || !(item instanceof ArmorItem)) continue;
                items.add((Object)new ItemStack((IItemProvider)item));
            }
        }
    }
}

