/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.threetag.threecore.ability.AbilityGenerator;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.capability.ItemAbilityContainerProvider;

public class PickaxeAbilityItem
extends PickaxeItem
implements IAbilityProvider {
    private List<AbilityGenerator> abilityGenerators;

    public PickaxeAbilityItem(IItemTier itemTier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(itemTier, attackDamage, attackSpeed, properties);
    }

    public PickaxeAbilityItem setAbilities(List<AbilityGenerator> abilities) {
        this.abilityGenerators = abilities;
        return this;
    }

    public PickaxeAbilityItem addAbility(AbilityGenerator abilityGenerator) {
        if (this.abilityGenerators == null) {
            this.abilityGenerators = Lists.newArrayList();
        }
        this.abilityGenerators.add(abilityGenerator);
        return this;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemAbilityContainerProvider(stack);
    }

    @Override
    public AbilityMap getAbilities() {
        return new AbilityMap(this.abilityGenerators);
    }
}

