/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.LazyLoadBase;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.threetag.threecore.ability.AbilityGenerator;
import net.threetag.threecore.ability.AbilityMap;
import net.threetag.threecore.ability.IAbilityProvider;
import net.threetag.threecore.capability.ItemAbilityContainerProvider;

public class ShieldAbilityItem
extends ShieldItem
implements IAbilityProvider {
    private List<AbilityGenerator> abilityGenerators;
    private final int useDuration;
    private final LazyLoadBase<Ingredient> repairMaterial;

    public ShieldAbilityItem(Item.Properties properties, int useDuration, Supplier<Ingredient> repairMaterial) {
        super(properties);
        this.useDuration = useDuration;
        this.repairMaterial = new LazyLoadBase(repairMaterial);
    }

    public int func_77626_a(ItemStack stack) {
        return this.useDuration;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repairMaterial) {
        return ((Ingredient)this.repairMaterial.func_179281_c()).test(repairMaterial);
    }

    public ShieldAbilityItem setAbilities(List<AbilityGenerator> abilities) {
        this.abilityGenerators = abilities;
        return this;
    }

    public ShieldAbilityItem addAbility(AbilityGenerator abilityGenerator) {
        if (this.abilityGenerators == null) {
            this.abilityGenerators = Lists.newArrayList();
        }
        this.abilityGenerators.add(abilityGenerator);
        return this;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ItemAbilityContainerProvider(stack);
    }

    @Override
    public AbilityMap getAbilities() {
        return new AbilityMap(this.abilityGenerators);
    }
}

