/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.FluidContainerColorer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.util.TCFluidUtil;

public class VialItem
extends Item {
    public VialItem(Item.Properties properties) {
        super(properties);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null && this.func_194125_a(group)) {
            ForgeRegistries.FLUIDS.getEntries().forEach(entry -> {
                ItemStack stack = new ItemStack((IItemProvider)this);
                if (!((ResourceLocation)entry.getKey()).toString().equalsIgnoreCase("minecraft:empty")) {
                    if (entry.getValue() instanceof FlowingFluid) {
                        if (((FlowingFluid)entry.getValue()).func_210198_f() == entry.getValue()) {
                            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack(((FlowingFluid)entry.getValue()).func_210198_f(), 500), IFluidHandler.FluidAction.EXECUTE));
                            items.add((Object)stack);
                        }
                    } else {
                        stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack((Fluid)entry.getValue(), 500), IFluidHandler.FluidAction.EXECUTE));
                        items.add((Object)stack);
                    }
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY != null) {
            stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fluidHandler -> {
                FluidStack fluidStack = fluidHandler.getFluidInTank(0);
                if (!fluidStack.isEmpty()) {
                    tooltip.add(fluidStack.getDisplayName().func_212638_h().func_211708_a(TextFormatting.GRAY));
                    tooltip.add(new StringTextComponent(TCFluidUtil.getFormattedFluidInfo(fluidStack.getAmount(), fluidHandler.getTankCapacity(0))).func_211708_a(TextFormatting.GRAY));
                }
            });
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack(stack, 500);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemColor
    extends FluidContainerColorer {
        public int getColor(@Nonnull ItemStack stack, int tintIndex) {
            FluidStack fluidStack = (FluidStack)FluidUtil.getFluidContained((ItemStack)stack).orElse((Object)FluidStack.EMPTY);
            if (!fluidStack.isEmpty() && fluidStack.getFluid().func_207187_a((Fluid)Fluids.field_204547_b) && tintIndex == 1) {
                return 16738048;
            }
            return super.getColor(stack, tintIndex);
        }
    }
}

