/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.ability.IAbilityContainer;

public class AddAbilityMessage {
    public int entityID;
    public ResourceLocation containerId;
    public String abilityId;
    public CompoundNBT data;

    public AddAbilityMessage(int entityID, ResourceLocation containerId, String abilityId, CompoundNBT data) {
        this.entityID = entityID;
        this.containerId = containerId;
        this.abilityId = abilityId;
        this.data = data;
    }

    public AddAbilityMessage(PacketBuffer buffer) {
        this.entityID = buffer.readInt();
        this.containerId = new ResourceLocation(buffer.func_150789_c(64));
        this.abilityId = buffer.func_150789_c(32);
        this.data = buffer.func_150793_b();
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeInt(this.entityID);
        buffer.func_180714_a(this.containerId.toString());
        buffer.func_180714_a(this.abilityId);
        buffer.func_150786_a(this.data);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            AbilityType abilityType;
            IAbilityContainer container;
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
            if (entity != null && entity instanceof LivingEntity && (container = AbilityHelper.getAbilityContainerFromId((LivingEntity)entity, this.containerId)) != null && (abilityType = (AbilityType)AbilityType.REGISTRY.getValue(new ResourceLocation(this.data.func_74779_i("AbilityType")))) != null) {
                Ability ability = abilityType.create();
                ability.readUpdateTag(this.data);
                container.addAbility((LivingEntity)entity, this.abilityId, ability);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

