/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.event.RegisterThreeDataEvent;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.events.AbilityDataUpdatedScriptEvent;
import net.threetag.threecore.scripts.events.AbilityDisabledScriptEvent;
import net.threetag.threecore.scripts.events.AbilityEnabledScriptEvent;
import net.threetag.threecore.scripts.events.AbilityLockedScriptEvent;
import net.threetag.threecore.scripts.events.AbilityTickScriptEvent;
import net.threetag.threecore.scripts.events.AbilityUnlockedScriptEvent;
import net.threetag.threecore.scripts.events.ConditionDataUpdatedScriptEvent;
import net.threetag.threecore.scripts.events.EntityJoinWorldScriptEvent;
import net.threetag.threecore.scripts.events.EntityStruckByLightningScriptEvent;
import net.threetag.threecore.scripts.events.LivingAttackScriptEvent;
import net.threetag.threecore.scripts.events.LivingDeathScriptEvent;
import net.threetag.threecore.scripts.events.LivingFallScriptEvent;
import net.threetag.threecore.scripts.events.LivingHurtScriptEvent;
import net.threetag.threecore.scripts.events.LivingJumpScriptEvent;
import net.threetag.threecore.scripts.events.LivingUpdateScriptEvent;
import net.threetag.threecore.scripts.events.MultiJumpScriptEvent;
import net.threetag.threecore.scripts.events.ProjectileImpactScriptEvent;
import net.threetag.threecore.scripts.events.ProjectileTickScriptEvent;
import net.threetag.threecore.scripts.events.RegisterThreeDataScriptEvent;
import net.threetag.threecore.scripts.events.ScriptEvent;

public class ScriptEventManager {
    private static Map<Class<? extends ScriptEvent>, List<IEventHandler>> subscribed = Maps.newHashMap();
    private static Map<String, Class<? extends ScriptEvent>> events = Maps.newHashMap();

    public static void reset() {
        subscribed.clear();
    }

    public static void subscribe(Class<? extends ScriptEvent> eventClass, IEventHandler eventHandler) {
        if (!subscribed.containsKey(eventClass)) {
            subscribed.put(eventClass, Lists.newLinkedList());
        }
        subscribed.get(eventClass).add(eventHandler);
    }

    public static void subscribe(String eventName, IEventHandler eventHandler) {
        Class<? extends ScriptEvent> clazz = events.get(eventName);
        if (clazz != null) {
            ScriptEventManager.subscribe(clazz, eventHandler);
        }
    }

    public static void registerEvent(String name, Class<? extends ScriptEvent> eventClass) {
        events.put(name, eventClass);
    }

    public static void fireEvent(ScriptEvent event) {
        if (subscribed.containsKey(event.getClass())) {
            subscribed.get(event.getClass()).forEach(inv -> inv.onEvent(event));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void generateHtmlFile(File file) {
        List<String> ignoredMethods = Arrays.asList("fire", "wait", "equals", "toString", "hashCode", "getClass", "notify", "notifyAll");
        try {
            String name;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            LinkedList lines = Lists.newLinkedList();
            lines.add("<html><head><title>Script Events</title><style>\ntable{font-family:arial, sans-serif;border-collapse:collapse;}\ntd,th{border:1px solid #666666;text-align:left;padding:8px;min-width:45px;}\nth{background-color:#CCCCCC;}\np{margin:0;}\ntr:nth-child(even){background-color:#D8D8D8;}\ntr:nth-child(odd){background-color:#EEEEEE;}\ntd.true{background-color:#72FF85AA;}\ntd.false{background-color:#FF6666AA;}\ntd.other{background-color:#42A3FFAA;}\ntd.error{color:#FF0000;}\nth,td.true,td.false,td.other{text-align:center;}\n</style><link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"https://i.imgur.com/am80ox1.png\"></head><body>");
            lines.add("<ul>");
            for (Map.Entry<String, Class<? extends ScriptEvent>> entry : events.entrySet()) {
                name = entry.getKey();
                lines.add("<li><a href=\"#" + name + "\">" + name + "</a></li>");
            }
            lines.add("</ul>");
            lines.add("<hr>\n");
            for (Map.Entry<String, Class<? extends ScriptEvent>> entry : events.entrySet()) {
                name = entry.getKey();
                Class<? extends ScriptEvent> clazz = entry.getValue();
                lines.add("<p><h1 id=\"" + name + "\">" + name + "</h1>");
                lines.add("<table>\n<tr><th>Function</th><th>Return Type</th><th>Parameters</th></tr>");
                for (Method method : clazz.getMethods()) {
                    if (ignoredMethods.contains(method.getName())) continue;
                    lines.add("<tr>");
                    lines.add("<td>" + method.getName() + "</td>");
                    lines.add("<td>" + method.getReturnType().getSimpleName() + "</td>");
                    lines.add("<td>");
                    if (method.getParameterCount() <= 0) {
                        lines.add("/");
                    } else {
                        for (int i = 0; i < method.getParameterCount(); ++i) {
                            String parameterName = method.getParameters()[i].getName();
                            ScriptParameterName scriptParameterName = method.getParameters()[i].getAnnotation(ScriptParameterName.class);
                            if (scriptParameterName != null) {
                                parameterName = scriptParameterName.value();
                            }
                            lines.add("<strong>" + parameterName + "</strong> - " + method.getParameterTypes()[i].getSimpleName());
                            if (method.getParameterCount() <= 1 || i - 2 > method.getParameterCount()) continue;
                            lines.add("<br>");
                        }
                    }
                    lines.add("</td>");
                    lines.add("</tr>");
                }
                lines.add("</table>");
                lines.add("</p><hr>\n");
            }
            for (String s : lines) {
                bw.write(s + "\n");
            }
            bw.close();
            ThreeCore.LOGGER.info("Successfully generated script_events.html!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        ScriptEventManager.registerEvent("entityJoinWorld", EntityJoinWorldScriptEvent.class);
        ScriptEventManager.registerEvent("entityStruckByLightning", EntityStruckByLightningScriptEvent.class);
        ScriptEventManager.registerEvent("livingUpdate", LivingUpdateScriptEvent.class);
        ScriptEventManager.registerEvent("livingJump", LivingJumpScriptEvent.class);
        ScriptEventManager.registerEvent("livingAttack", LivingAttackScriptEvent.class);
        ScriptEventManager.registerEvent("livingHurt", LivingHurtScriptEvent.class);
        ScriptEventManager.registerEvent("livingDeath", LivingDeathScriptEvent.class);
        ScriptEventManager.registerEvent("livingFall", LivingFallScriptEvent.class);
        ScriptEventManager.registerEvent("abilityTick", AbilityTickScriptEvent.class);
        ScriptEventManager.registerEvent("abilityLocked", AbilityLockedScriptEvent.class);
        ScriptEventManager.registerEvent("abilityUnlocked", AbilityUnlockedScriptEvent.class);
        ScriptEventManager.registerEvent("abilityEnabled", AbilityEnabledScriptEvent.class);
        ScriptEventManager.registerEvent("abilityDisabled", AbilityDisabledScriptEvent.class);
        ScriptEventManager.registerEvent("abilityDataUpdated", AbilityDataUpdatedScriptEvent.class);
        ScriptEventManager.registerEvent("conditionDataUpdated", ConditionDataUpdatedScriptEvent.class);
        ScriptEventManager.registerEvent("registerThreeData", RegisterThreeDataScriptEvent.class);
        ScriptEventManager.registerEvent("multiJump", MultiJumpScriptEvent.class);
        ScriptEventManager.registerEvent("projectileImpact", ProjectileImpactScriptEvent.class);
        ScriptEventManager.registerEvent("projectileTick", ProjectileTickScriptEvent.class);
    }

    @Mod.EventBusSubscriber(modid="threecore")
    public static class EventHandler {
        @SubscribeEvent
        public static void onLivingUpdate(LivingEvent.LivingUpdateEvent e) {
            new LivingUpdateScriptEvent(e.getEntityLiving()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingJump(LivingEvent.LivingJumpEvent e) {
            new LivingJumpScriptEvent(e.getEntityLiving()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinWorldEvent e) {
            new EntityJoinWorldScriptEvent(e.getEntity()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingAttack(LivingAttackEvent e) {
            new LivingAttackScriptEvent(e.getEntityLiving(), e.getSource(), e.getAmount()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent e) {
            new LivingDeathScriptEvent(e.getEntityLiving(), e.getSource()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onLivingFall(LivingFallEvent e) {
            LivingFallScriptEvent scriptEvent = new LivingFallScriptEvent(e.getEntityLiving(), e.getDistance(), e.getDamageMultiplier());
            scriptEvent.fire((Event)e);
            e.setDistance(scriptEvent.getDistance());
            e.setDamageMultiplier(scriptEvent.getDamageMultiplier());
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent e) {
            LivingHurtScriptEvent scriptEvent = new LivingHurtScriptEvent(e.getEntityLiving(), e.getSource(), e.getAmount());
            scriptEvent.fire((Event)e);
            e.setAmount(scriptEvent.getAmount());
        }

        @SubscribeEvent
        public static void onEntityStruckByLightning(EntityStruckByLightningEvent e) {
            new EntityStruckByLightningScriptEvent(e.getEntity(), e.getLightning()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onRegisterThreeData(RegisterThreeDataEvent e) {
            new RegisterThreeDataScriptEvent(e.getEntity(), e.getThreeData()).fire((Event)e);
        }

        @SubscribeEvent
        public static void onProjectileImpactEvent(ProjectileImpactEvent e) {
            new ProjectileImpactScriptEvent(e.getEntity()).fire((Event)e);
        }
    }

    public static interface IEventHandler {
        public void onEvent(ScriptEvent var1);
    }

    public static class EventManagerAccessor {
        public void on(String eventName, IEventHandler eventHandler) {
            if (eventHandler != null) {
                ScriptEventManager.subscribe(eventName, eventHandler);
            }
        }
    }
}

