/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.scripts.ScriptEventManager;
import net.threetag.threecore.scripts.bindings.BlockStateBuilder;
import net.threetag.threecore.scripts.bindings.ItemStackBuilder;
import net.threetag.threecore.scripts.bindings.MathHelper;
import net.threetag.threecore.scripts.bindings.ThreeDataBuilder;
import org.apache.commons.io.IOUtils;

@Mod.EventBusSubscriber(modid="threecore")
public class ScriptManager
extends ReloadListener<Map<ResourceLocation, String>> {
    public static ScriptManager INSTANCE;
    public static ScriptEngineManager manager;
    private static final int JSON_EXTENSION_LENGTH;
    private final String folder;
    private static final Map<String, Supplier<?>> bindings;
    private static final String[] BLOCKED_FUNCTIONS;

    public static void registerBinding(String name, Supplier<?> supplier) {
        bindings.put(name, supplier);
    }

    public ScriptManager() {
        INSTANCE = this;
        this.folder = "scripts";
    }

    protected Map<ResourceLocation, String> prepare(IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        int i = this.folder.length() + 1;
        for (ResourceLocation resourcelocation : resourceManagerIn.func_199003_a(this.folder, s -> s.endsWith(".js"))) {
            String s2 = resourcelocation.func_110623_a();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s2.substring(i, s2.length() - JSON_EXTENSION_LENGTH));
            try {
                IResource iresource = resourceManagerIn.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    InputStream inputstream = iresource.func_199027_b();
                    Throwable throwable2 = null;
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
                        Throwable throwable3 = null;
                        try {
                            String script = IOUtils.toString((Reader)reader);
                            if (script != null) {
                                String script1 = map.put(resourcelocation1, script);
                                if (script1 == null) continue;
                                throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
                            }
                            ThreeCore.LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)resourcelocation1, (Object)resourcelocation);
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable3 != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (inputstream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputstream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        inputstream.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (IOException | IllegalArgumentException exception) {
                ThreeCore.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourcelocation1, (Object)resourcelocation, (Object)exception);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, String> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        ScriptEventManager.reset();
        for (Map.Entry<ResourceLocation, String> entry : splashList.entrySet()) {
            try {
                ScriptEngine engine = manager.getEngineByName("javascript");
                ScriptContext context = engine.getContext();
                if (!(engine instanceof Invocable)) {
                    ThreeCore.LOGGER.error("Engine is not invocable?");
                    continue;
                }
                for (String s2 : BLOCKED_FUNCTIONS) {
                    context.removeAttribute(s2, context.getAttributesScope(s2));
                }
                engine.put("namespace", entry.getKey().toString());
                bindings.forEach((s, b) -> engine.put((String)s, b.get()));
                engine.eval(entry.getValue());
                ThreeCore.LOGGER.info("Executed script file {}!", (Object)entry.getKey());
            }
            catch (ScriptException e) {
                ThreeCore.LOGGER.error("Error when executing script file {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    @SubscribeEvent
    public static void serverAboutToStart(FMLServerAboutToStartEvent e) {
        e.getServer().func_195570_aG().func_219534_a((IFutureReloadListener)new ScriptManager());
    }

    static {
        manager = new ScriptEngineManager();
        JSON_EXTENSION_LENGTH = ".json".length();
        bindings = Maps.newHashMap();
        BLOCKED_FUNCTIONS = new String[]{"load", "loadWithNewGlobal", "exit", "quit"};
        ScriptManager.registerBinding("eventManager", ScriptEventManager.EventManagerAccessor::new);
        ScriptManager.registerBinding("threeDataBuilder", ThreeDataBuilder::new);
        ScriptManager.registerBinding("blockStateBuilder", BlockStateBuilder::new);
        ScriptManager.registerBinding("itemStackBuilder", ItemStackBuilder::new);
        ScriptManager.registerBinding("mathHelper", MathHelper::new);
    }
}

