/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.accessors;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.accessors.AbilityAccessor;
import net.threetag.threecore.scripts.accessors.EntityAccessor;
import net.threetag.threecore.scripts.accessors.ItemStackAccessor;

public class LivingEntityAccessor
extends EntityAccessor {
    public final LivingEntity livingEntity;

    protected LivingEntityAccessor(LivingEntity entity) {
        super((Entity)entity);
        this.livingEntity = entity;
    }

    public boolean isChild() {
        return this.livingEntity.func_70631_g_();
    }

    public float getHealth() {
        return this.livingEntity.func_110143_aJ();
    }

    public void setHealth(@ScriptParameterName(value="health") float health) {
        this.livingEntity.func_70606_j(health);
    }

    public float getMaxHealth() {
        return this.livingEntity.func_110138_aP();
    }

    public void heal(@ScriptParameterName(value="amount") float amount) {
        this.livingEntity.func_70691_i(amount);
    }

    public boolean isUndead() {
        return this.livingEntity.func_70662_br();
    }

    public boolean isOnLadder() {
        return this.livingEntity.func_70617_f_();
    }

    public boolean isSleeping() {
        return this.livingEntity.func_70608_bn();
    }

    public boolean isElytraFlying() {
        return this.livingEntity.func_184613_cA();
    }

    public float getAbsorptionAmount() {
        return this.livingEntity.func_110139_bj();
    }

    public float getMovementSpeed() {
        return this.livingEntity.func_70689_ay();
    }

    public void setMovementSpeed(@ScriptParameterName(value="speed") float speed) {
        this.livingEntity.func_70659_e(speed);
    }

    public void swingArm(@ScriptParameterName(value="mainHand") boolean mainHand) {
        if (this.livingEntity.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.livingEntity.field_70170_p).func_72863_F().func_217216_a((Entity)this.livingEntity, (IPacket)new SAnimateHandPacket((Entity)this.livingEntity, mainHand ? 0 : 3));
        }
    }

    public ItemStackAccessor getItemInSlot(@ScriptParameterName(value="slot") String slot) {
        try {
            EquipmentSlotType slotType = EquipmentSlotType.func_188451_a((String)slot);
            return new ItemStackAccessor(this.livingEntity.func_184582_a(slotType));
        }
        catch (Exception e) {
            return ItemStackAccessor.EMPTY;
        }
    }

    public void setItemInSlot(@ScriptParameterName(value="slot") String slot, @ScriptParameterName(value="item") Object item) {
        try {
            EquipmentSlotType slotType = EquipmentSlotType.func_188451_a((String)slot);
            ItemStackAccessor stack = item instanceof ItemStackAccessor ? (ItemStackAccessor)item : new ItemStackAccessor(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(item.toString()))));
            this.livingEntity.func_184201_a(slotType, (ItemStack)stack.value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AbilityAccessor[] getAbilities() {
        List<Ability> list = AbilityHelper.getAbilities(this.livingEntity);
        AbilityAccessor[] array = new AbilityAccessor[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = new AbilityAccessor(list.get(i));
        }
        return array;
    }

    public AbilityAccessor[] getAbilities(@ScriptParameterName(value="containerId") String containerId) {
        IAbilityContainer container = AbilityHelper.getAbilityContainerFromId(this.livingEntity, new ResourceLocation(containerId));
        if (container != null) {
            return new AbilityAccessor[0];
        }
        Collection list = container.getAbilities().stream().map(a -> new AbilityAccessor((Ability)a)).collect(Collectors.toList());
        AbilityAccessor[] array = new AbilityAccessor[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbilityAccessor abilityAccessor;
            array[i] = abilityAccessor = (AbilityAccessor)iterator.next();
            ++i;
        }
        return array;
    }

    public AbilityAccessor getAbilityById(@ScriptParameterName(value="abilityId") String id) {
        return (AbilityAccessor)AbilityAccessor.makeAccessor(AbilityHelper.getAbilityById(this.livingEntity, id, null));
    }
}

