/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.scripts.accessors;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.scripts.ScriptCommandSource;
import net.threetag.threecore.scripts.ScriptParameterName;
import net.threetag.threecore.scripts.accessors.BlockStateAccessor;
import net.threetag.threecore.scripts.accessors.ScriptAccessor;
import net.threetag.threecore.util.PlayerUtil;

public class WorldAccessor
extends ScriptAccessor<World> {
    public WorldAccessor(World value) {
        super(value);
    }

    public long getTime() {
        return ((World)this.value).func_72820_D();
    }

    public void setTime(@ScriptParameterName(value="time") long time) {
        ((World)this.value).func_72877_b(time);
    }

    public boolean isRaining() {
        return ((World)this.value).func_72896_J();
    }

    public boolean isThundering() {
        return ((World)this.value).func_72911_I();
    }

    public void setRainStrength(@ScriptParameterName(value="strength") float strength) {
        ((World)this.value).func_72894_k(strength);
    }

    public void playSound(@ScriptParameterName(value="id") String id, @ScriptParameterName(value="id") String soundCategory, @ScriptParameterName(value="posX") double posX, @ScriptParameterName(value="posY") double posY, @ScriptParameterName(value="posZ") double posZ, @ScriptParameterName(value="volume") float volume, @ScriptParameterName(value="pitch") float pitch) {
        SoundEvent soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(id));
        SoundCategory category = null;
        for (SoundCategory category1 : SoundCategory.values()) {
            if (!category1.func_187948_a().equalsIgnoreCase(soundCategory)) continue;
            category = category1;
            break;
        }
        if (soundEvent != null && category != null) {
            PlayerUtil.playSoundToAll((World)this.value, posX, posY, posZ, 50.0, soundEvent, category, volume, pitch);
        }
    }

    public void summonLightning(@ScriptParameterName(value="x") double x, @ScriptParameterName(value="y") double y, @ScriptParameterName(value="z") double z, @ScriptParameterName(value="effectOnly") boolean effectOnly) {
        if (this.value instanceof ServerWorld) {
            ((ServerWorld)this.value).func_217468_a(new LightningBoltEntity((World)this.value, x, y, z, effectOnly));
        }
    }

    public void setBlockState(@ScriptParameterName(value="block") Object block, @ScriptParameterName(value="x") int x, @ScriptParameterName(value="y") int y, @ScriptParameterName(value="z") int z) {
        BlockState b;
        Object object = block instanceof BlockStateAccessor ? (BlockState)((BlockStateAccessor)block).value : (b = block instanceof String && ForgeRegistries.BLOCKS.containsKey(new ResourceLocation((String)block)) ? ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)block))).func_176223_P() : null);
        if (block != null) {
            ((World)this.value).func_175656_a(new BlockPos(x, y, z), b);
        }
    }

    public BlockStateAccessor getBlockState(@ScriptParameterName(value="x") int x, @ScriptParameterName(value="y") int y, @ScriptParameterName(value="z") int z) {
        return (BlockStateAccessor)ScriptAccessor.makeAccessor(((World)this.value).func_180495_p(new BlockPos(x, y, z)));
    }

    public void executeCommand(@ScriptParameterName(value="command") String command) {
        if (this.value instanceof ServerWorld) {
            CommandSource commandSource = new CommandSource((ICommandSource)new ScriptCommandSource(), new Vec3d((Vec3i)((World)this.value).func_175694_M()), Vec2f.field_189974_a, (ServerWorld)this.value, 4, "Script", (ITextComponent)new StringTextComponent("Script"), ((World)this.value).func_73046_m(), (Entity)null);
            ((World)this.value).func_73046_m().func_195571_aL().func_197059_a(commandSource, command);
        }
    }
}

