/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.sizechanging;

import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.threetag.threecore.capability.ISizeChanging;
import net.threetag.threecore.entity.attributes.TCAttributes;
import net.threetag.threecore.sizechanging.SizeChangeType;

public class DefaultSizeChangeType
extends SizeChangeType {
    @Override
    public int getSizeChangingTime(Entity entity, ISizeChanging data, float estimatedSize) {
        return 60;
    }

    @Override
    public void onSizeChanged(Entity entity, ISizeChanging data, float size) {
        if (entity instanceof LivingEntity) {
            AbstractAttributeMap map = ((LivingEntity)entity).func_110140_aT();
            this.setAttribute(map, SharedMonsterAttributes.field_111263_d, (double)(size - 1.0f) * 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, TCAttributes.JUMP_HEIGHT, (double)(size - 1.0f) * 1.0, AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, TCAttributes.FALL_RESISTANCE, size > 1.0f ? (double)(1.0f / size) : (double)size, AttributeModifier.Operation.MULTIPLY_BASE, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, SharedMonsterAttributes.field_111264_e, (double)(size - 1.0f) * 1.0, AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, PlayerEntity.REACH_DISTANCE, (double)(size - 1.0f) * 1.0, AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, SharedMonsterAttributes.field_111266_c, (double)(size - 1.0f) * 0.5, AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            this.changeCreeperExplosionRadius(entity, size);
            this.spawnWaterParticles(entity);
        }
    }

    public void changeCreeperExplosionRadius(Entity entity, float size) {
        if (entity instanceof CreeperEntity) {
            ((CreeperEntity)entity).field_82226_g = (int)(3.0f * size);
        }
    }

    public void spawnWaterParticles(Entity entity) {
        double z;
        double y;
        AxisAlignedBB box = entity.func_174813_aQ();
        Random random = new Random();
        double x = box.field_72340_a + (box.field_72336_d - box.field_72340_a) * random.nextDouble();
        if (entity.field_70170_p.func_201671_F(new BlockPos(x, y = box.field_72338_b + (box.field_72337_e - box.field_72338_b) * random.nextDouble(), z = box.field_72339_c + (box.field_72334_f - box.field_72339_c) * random.nextDouble()))) {
            entity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onUpdate(Entity entity, ISizeChanging data, float size) {
    }

    @Override
    public boolean start(Entity entity, ISizeChanging data, float size, float estimatedSize) {
        return true;
    }

    @Override
    public void end(Entity entity, ISizeChanging data, float size) {
    }

    public void setAttribute(AbstractAttributeMap map, IAttribute attribute, double value, AttributeModifier.Operation operation, UUID uuid) {
        if (map.func_111151_a(attribute) != null) {
            IAttributeInstance instance = map.func_111151_a(attribute);
            if (instance.func_111127_a(uuid) != null) {
                instance.func_188479_b(uuid);
            }
            instance.func_111121_a(new AttributeModifier(uuid, "default_size_changer", value, operation));
        }
    }
}

