/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.sizechanging;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.util.RenderUtil;

public class SizeManager {
    public static final IAttribute SIZE_WIDTH = new RangedAttribute(null, "threecore.sizeWidth", 1.0, 0.1, 32.0).func_111112_a(true);
    public static final IAttribute SIZE_HEIGHT = new RangedAttribute(null, "threecore.sizeHeight", 1.0, 0.1, 32.0).func_111112_a(true);

    public static Vec2f getSize(Entity entity, Pose pose) {
        AtomicReference<Float> width = new AtomicReference<Float>(Float.valueOf(1.0f));
        AtomicReference<Float> height = new AtomicReference<Float>(Float.valueOf(1.0f));
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(s -> {
            width.set(Float.valueOf(s.getWidth()));
            height.set(Float.valueOf(s.getHeight()));
        });
        return new Vec2f(width.get().floatValue(), height.get().floatValue());
    }

    public static void entityTick(Entity entity) {
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(s -> s.tick());
    }

    public static EntitySize getOverridenSize(EntitySize entitySize, Entity entity, Pose pose) {
        Vec2f vec = SizeManager.getSize(entity, pose);
        return new EntitySize(entitySize.field_220315_a * vec.field_189982_i, entitySize.field_220316_b * vec.field_189983_j, entitySize.field_220317_c);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void scaleEntity(Entity entity, double x, double y, double z) {
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            float width = sizeChanging.getRenderWidth(RenderUtil.renderTickTime);
            float height = sizeChanging.getRenderHeight(RenderUtil.renderTickTime);
            GlStateManager.scalef((float)width, (float)height, (float)width);
            GlStateManager.translated((double)(x / (double)width - x), (double)(y / (double)height - y), (double)(z / (double)width - z));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderInInvCallback(LivingEntity entity) {
        entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).ifPresent(sizeChanging -> {
            float width = 1.0f / sizeChanging.getRenderWidth(RenderUtil.renderTickTime);
            GlStateManager.scalef((float)width, (float)(1.0f / sizeChanging.getRenderHeight(RenderUtil.renderTickTime)), (float)width);
        });
    }
}

