/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.container.HydraulicPressContainer;
import net.threetag.threecore.item.ItemStackHandlerExt;
import net.threetag.threecore.item.recipe.PressingRecipe;
import net.threetag.threecore.tileentity.ProgressableMachineTileEntity;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.energy.IEnergyConfig;

public class HydraulicPressTileEntity
extends ProgressableMachineTileEntity<PressingRecipe> {
    protected final IIntArray intArray = new IIntArray(){

        public int func_221476_a(int i) {
            switch (i) {
                case 0: {
                    return HydraulicPressTileEntity.this.progress;
                }
                case 1: {
                    return HydraulicPressTileEntity.this.maxProgress;
                }
                case 2: {
                    return HydraulicPressTileEntity.this.energyStorage.getEnergyStored();
                }
                case 3: {
                    return HydraulicPressTileEntity.this.energyStorage.getMaxEnergyStored();
                }
            }
            return 0;
        }

        public void func_221477_a(int i, int value) {
            switch (i) {
                case 0: {
                    HydraulicPressTileEntity.this.progress = value;
                }
                case 1: {
                    HydraulicPressTileEntity.this.maxProgress = value;
                }
                case 2: {
                    HydraulicPressTileEntity.this.energyStorage.setEnergyStored(value);
                }
                case 3: {
                    HydraulicPressTileEntity.this.energyStorage.setMaxEnergyStored(value);
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    private ItemStackHandlerExt energySlot = new ItemStackHandlerExt(1).setValidator((TriPredicate<ItemStackHandlerExt, Integer, ItemStack>)((TriPredicate)(handler, slot, stack) -> stack.getCapability(CapabilityEnergy.ENERGY).isPresent())).setChangedCallback((handler, slot) -> this.func_70296_d());
    private ItemStackHandlerExt inputSlot = new ItemStackHandlerExt(2){

        public int getSlotLimit(int slot) {
            return slot == 0 ? 1 : super.getSlotLimit(slot);
        }
    }.setChangedCallback((handler, slot) -> {
        this.updateRecipe((IInventory)this.recipeWrapper);
        this.func_70296_d();
    });
    private ItemStackHandlerExt outputSlots = new ItemStackHandlerExt(1).setValidator((TriPredicate<ItemStackHandlerExt, Integer, ItemStack>)((TriPredicate)(handler, slot, stack) -> false)).setChangedCallback((handler, slot) -> this.func_70296_d());
    private CombinedInvWrapper combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.energySlot, this.inputSlot, this.outputSlots});
    public RecipeWrapper recipeWrapper = new RecipeWrapper((IItemHandlerModifiable)this.inputSlot);
    private LazyOptional<IItemHandlerModifiable> combinedInvLazyOptional = LazyOptional.of(() -> this.combinedHandler);
    private LazyOptional<IItemHandlerModifiable> inputLazyOptional = LazyOptional.of(() -> this.inputSlot);
    private LazyOptional<IItemHandlerModifiable> outputLazyOptional = LazyOptional.of(() -> this.outputSlots);
    private LazyOptional<IItemHandlerModifiable> energySlotLazyOptional = LazyOptional.of(() -> this.energySlot);

    public HydraulicPressTileEntity() {
        super((TileEntityType)TCTileEntityTypes.HYDRAULIC_PRESS.get());
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.threecore.hydraulic_press", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new HydraulicPressContainer(id, playerInventory, this, this.intArray);
    }

    @Override
    public IEnergyConfig getEnergyConfig() {
        return ThreeCoreServerConfig.ENERGY.HYDRAULIC_PRESS;
    }

    @Override
    public IRecipeType getRecipeType() {
        return PressingRecipe.RECIPE_TYPE;
    }

    @Override
    public float getXpFromRecipe(PressingRecipe recipe) {
        return recipe.getExperience();
    }

    @Override
    public IItemHandler getEnergyInputSlots() {
        return this.energySlot;
    }

    @Override
    public boolean canWork(PressingRecipe recipe) {
        ItemStack recipeOutput = recipe.func_77571_b();
        if (recipeOutput.func_190926_b()) {
            return false;
        }
        ItemStack outputSlot = this.outputSlots.getStackInSlot(0);
        boolean output = outputSlot.func_190926_b() ? true : (!outputSlot.func_77969_a(recipeOutput) ? false : (outputSlot.func_190916_E() + recipeOutput.func_190916_E() <= this.outputSlots.getSlotLimit(0) && outputSlot.func_190916_E() < outputSlot.func_77976_d() ? true : outputSlot.func_190916_E() + recipeOutput.func_190916_E() <= recipeOutput.func_77976_d()));
        return output;
    }

    @Override
    public void produceOutput(PressingRecipe recipe) {
        ItemStack recipeOutput = recipe.func_77571_b();
        ItemStack outputSlot = this.outputSlots.getStackInSlot(0);
        if (outputSlot.func_190926_b()) {
            this.outputSlots.setStackInSlot(0, recipeOutput.func_77946_l());
        } else if (outputSlot.func_77973_b() == recipeOutput.func_77973_b()) {
            outputSlot.func_190917_f(recipeOutput.func_190916_E());
        }
        this.inputSlot.getStackInSlot(1).func_190918_g(1);
        this.updateRecipe((IInventory)this.recipeWrapper);
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("EnergySlots")) {
            this.energySlot.deserializeNBT(nbt.func_74775_l("EnergySlots"));
        }
        if (nbt.func_74764_b("InputSlots")) {
            this.inputSlot.deserializeNBT(nbt.func_74775_l("InputSlots"));
        }
        if (nbt.func_74764_b("OutputSlots")) {
            this.outputSlots.deserializeNBT(nbt.func_74775_l("OutputSlots"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_218657_a("EnergySlots", (INBT)this.energySlot.serializeNBT());
        nbt.func_218657_a("InputSlots", (INBT)this.inputSlot.serializeNBT());
        nbt.func_218657_a("OutputSlots", (INBT)this.outputSlots.serializeNBT());
        return nbt;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.combinedInvLazyOptional.cast();
            }
            if (side == Direction.UP) {
                return this.inputLazyOptional.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputLazyOptional.cast();
            }
            return this.energySlotLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

