/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.TriPredicate;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.block.StirlingGeneratorBlock;
import net.threetag.threecore.container.StirlingGeneratorContainer;
import net.threetag.threecore.fluid.FluidTankExt;
import net.threetag.threecore.item.ItemStackHandlerExt;
import net.threetag.threecore.tileentity.MachineTileEntity;
import net.threetag.threecore.tileentity.TCTileEntityTypes;
import net.threetag.threecore.util.PlayerUtil;
import net.threetag.threecore.util.TCFluidUtil;
import net.threetag.threecore.util.energy.IEnergyConfig;
import net.threetag.threecore.util.energy.IEnergyStorageModifiable;
import net.threetag.threecore.util.energy.NoReceiveEnergyWrapper;

public class StirlingGeneratorTileEntity
extends MachineTileEntity {
    public static final int TANK_CAPACITY = 5000;
    protected final IIntArray intArray = new IIntArray(){

        public int func_221476_a(int i) {
            switch (i) {
                case 0: {
                    return StirlingGeneratorTileEntity.this.burnTime;
                }
                case 1: {
                    return StirlingGeneratorTileEntity.this.maxBurnTime;
                }
                case 2: {
                    return StirlingGeneratorTileEntity.this.energyStorage.getEnergyStored();
                }
                case 3: {
                    return StirlingGeneratorTileEntity.this.energyStorage.getMaxEnergyStored();
                }
            }
            return 0;
        }

        public void func_221477_a(int i, int value) {
            switch (i) {
                case 0: {
                    StirlingGeneratorTileEntity.this.burnTime = value;
                }
                case 1: {
                    StirlingGeneratorTileEntity.this.maxBurnTime = value;
                }
                case 2: {
                    StirlingGeneratorTileEntity.this.energyStorage.setEnergyStored(value);
                }
                case 3: {
                    StirlingGeneratorTileEntity.this.energyStorage.setMaxEnergyStored(value);
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    public FluidTank fluidTank = new FluidTankExt(5000).setCallback(f -> {
        if (this.func_145831_w() != null) {
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 3);
        }
    }).setSoundHandler(sound -> {
        if (sound != null) {
            PlayerUtil.playSoundToAll(this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), 50.0, sound, SoundCategory.BLOCKS);
        }
    }).setValidator(fluidStack -> fluidStack.getFluid().func_207185_a(FluidTags.field_206959_a));
    private ItemStackHandlerExt fuelSlot = new ItemStackHandlerExt(1).setValidator((TriPredicate<ItemStackHandlerExt, Integer, ItemStack>)((TriPredicate)(handler, slot, stack) -> AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack))).setChangedCallback((handler, slot) -> this.func_70296_d());
    private ItemStackHandlerExt fluidSlots = new ItemStackHandlerExt(4){

        public int getSlotLimit(int slot) {
            return 1;
        }
    }.setValidator((TriPredicate<ItemStackHandlerExt, Integer, ItemStack>)((TriPredicate)(handler, slot, stack) -> FluidUtil.getFluidHandler((ItemStack)stack).isPresent())).setChangedCallback((handler, slot) -> {
        this.func_70296_d();
        FluidTank tank = this.fluidTank;
        if (slot == 0 || slot == 2) {
            FluidActionResult res = TCFluidUtil.transferFluidFromItemToTank(handler.getStackInSlot(slot), (IFluidHandler)tank, (IItemHandler)handler, null);
            if (res.isSuccess()) {
                handler.setStackInSlot(slot, res.getResult());
            }
        } else {
            FluidActionResult res = TCFluidUtil.transferFluidFromTankToItem(handler.getStackInSlot(slot), (IFluidHandler)tank, (IItemHandler)handler, null);
            if (res.isSuccess()) {
                handler.setStackInSlot(slot, res.getResult());
            }
        }
    });
    protected int burnTime;
    protected int maxBurnTime;
    private CombinedInvWrapper combinedHandler = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.fuelSlot, this.fluidSlots});
    private LazyOptional<IItemHandlerModifiable> combinedInvLazyOptional = LazyOptional.of(() -> this.combinedHandler);
    private LazyOptional<IItemHandlerModifiable> fuelSlotLazyOptional = LazyOptional.of(() -> this.fuelSlot);
    private LazyOptional<IItemHandlerModifiable> inputFluidSlotLazyOptional = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.fluidSlots, 0, 1));
    private LazyOptional<IItemHandlerModifiable> outputFluidSlotLazyOptional = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.fluidSlots, 1, 2));
    private LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> this.fluidTank);

    public StirlingGeneratorTileEntity() {
        super((TileEntityType)TCTileEntityTypes.STIRLING_GENERATOR.get());
    }

    @Override
    protected IEnergyStorageModifiable createEnergyStorage(int energy) {
        return new NoReceiveEnergyWrapper(super.createEnergyStorage(energy));
    }

    @Override
    public IEnergyConfig getEnergyConfig() {
        return ThreeCoreServerConfig.ENERGY.STIRLING_GENERATOR;
    }

    @Override
    public void func_73660_a() {
        boolean lit;
        boolean currentLit = this.burnTime > 0;
        ItemStack fuel = this.fuelSlot.getStackInSlot(0);
        if (this.burnTime <= 0 && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() && !fuel.func_190926_b() && AbstractFurnaceTileEntity.func_213991_b((ItemStack)fuel) & !this.fluidTank.getFluid().isEmpty() && this.fluidTank.getFluid().getFluid().func_207185_a(FluidTags.field_206959_a) && !this.fluidTank.drain(100, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            this.burnTime = this.maxBurnTime = ForgeHooks.getBurnTime((ItemStack)fuel);
            this.fluidTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
            if (fuel.hasContainerItem()) {
                this.fuelSlot.setStackInSlot(0, fuel.getContainerItem());
            } else {
                fuel.func_190918_g(1);
            }
        }
        if (this.burnTime > 0) {
            if (this.burnTime % 900 == 0) {
                if (!this.fluidTank.drain(100, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    this.fluidTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
                    --this.burnTime;
                    this.energyStorage.receiveEnergy(10, false);
                }
            } else {
                --this.burnTime;
                this.energyStorage.modifyEnergy(10);
            }
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            for (Direction direction : Direction.values()) {
                TileEntity tileEntity;
                if (direction == Direction.UP || (tileEntity = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(direction))) == null || tileEntity instanceof StirlingGeneratorTileEntity) continue;
                tileEntity.getCapability(CapabilityEnergy.ENERGY, direction.func_176734_d()).ifPresent(energyStorage -> {
                    if (energyStorage.canReceive()) {
                        this.energyStorage.modifyEnergy(-energyStorage.receiveEnergy(Math.min(this.energyStorage.getEnergyStored(), this.energyStorage.getMaxExtract()), false));
                    }
                });
            }
        }
        boolean bl = lit = this.burnTime > 0;
        if (currentLit != lit) {
            this.func_70296_d();
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((IProperty)StirlingGeneratorBlock.LIT, (Comparable)Boolean.valueOf(lit)), 3);
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.threecore.stirling_generator", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new StirlingGeneratorContainer(id, player, this, this.intArray);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.fluidTank.readFromNBT(tag.func_74775_l("FluidTank"));
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("FluidTank", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(CompoundNBT nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("FuelSlots")) {
            this.fuelSlot.deserializeNBT(nbt.func_74775_l("FuelSlots"));
        }
        if (nbt.func_74764_b("FluidSlots")) {
            this.fluidSlots.deserializeNBT(nbt.func_74775_l("FluidSlots"));
        }
        this.fluidTank.readFromNBT(nbt.func_74775_l("FluidTank"));
        this.burnTime = nbt.func_74762_e("BurnTime");
        this.maxBurnTime = nbt.func_74762_e("MaxBurnTime");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("FuelSlots", (INBT)this.fuelSlot.serializeNBT());
        nbt.func_218657_a("FluidSlots", (INBT)this.fluidSlots.serializeNBT());
        nbt.func_218657_a("FluidTank", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        nbt.func_74768_a("BurnTime", this.burnTime);
        nbt.func_74768_a("MaxBurnTime", this.maxBurnTime);
        return super.func_189515_b(nbt);
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.combinedInvLazyOptional.cast();
            }
            if (side == Direction.UP) {
                return this.fuelSlotLazyOptional.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputFluidSlotLazyOptional.cast();
            }
            return this.inputFluidSlotLazyOptional.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }
}

