/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityUtil {
    public static Entity getEntityByUUID(World world, UUID uuid) {
        if (world instanceof ServerWorld) {
            return ((ServerWorld)world).func_217461_a(uuid);
        }
        if (world instanceof ClientWorld) {
            for (Entity entity : ((ClientWorld)world).func_217416_b()) {
                if (!entity.func_110124_au().equals(uuid)) continue;
                return entity;
            }
        }
        return null;
    }

    public static void spawnXP(World world, double x, double y, double z, int amount, float value) {
        int i;
        if (value == 0.0f) {
            amount = 0;
        } else if (value < 1.0f) {
            i = MathHelper.func_76141_d((float)((float)amount * value));
            if (i < MathHelper.func_76123_f((float)((float)amount * value)) && Math.random() < (double)((float)amount * value - (float)i)) {
                ++i;
            }
            amount = i;
        }
        while (amount > 0) {
            i = ExperienceOrbEntity.func_70527_a((int)amount);
            amount -= i;
            world.func_217376_c((Entity)new ExperienceOrbEntity(world, x, y, z, i));
        }
    }

    public static RayTraceResult rayTraceWithEntities(Entity entityIn, double distance, RayTraceContext.BlockMode blockModeIn, RayTraceContext.FluidMode fluidModeIn) {
        return EntityUtil.rayTraceWithEntities(entityIn, distance, blockModeIn, fluidModeIn, e -> true);
    }

    public static RayTraceResult rayTraceWithEntities(Entity entityIn, double distance, RayTraceContext.BlockMode blockModeIn, RayTraceContext.FluidMode fluidModeIn, Predicate<Entity> entityPredicate) {
        Vec3d lookVec = entityIn.func_70040_Z();
        Vec3d startVec = entityIn.func_213303_ch().func_72441_c(0.0, (double)entityIn.func_70047_e(), 0.0);
        Vec3d endVec = startVec.func_178787_e(entityIn.func_70040_Z().func_186678_a(distance));
        BlockRayTraceResult blockResult = entityIn.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, blockModeIn, fluidModeIn, entityIn));
        EntityRayTraceResult entityResult = null;
        int i = 0;
        while ((double)i < distance * 2.0 && entityResult == null) {
            float scale = (float)i / 2.0f;
            Vec3d pos = startVec.func_178787_e(lookVec.func_186678_a((double)scale));
            Vec3d min = pos.func_72441_c(0.25, 0.25, 0.25);
            Vec3d max = pos.func_72441_c(-0.25, -0.25, -0.25);
            for (Entity entity : entityIn.field_70170_p.func_72839_b(entityIn, new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c))) {
                if (!entityPredicate.test(entity)) continue;
                entityResult = new EntityRayTraceResult(entity, pos);
                break;
            }
            ++i;
        }
        if (entityResult != null && entityResult.func_216347_e().func_72438_d(startVec) <= blockResult.func_216347_e().func_72438_d(startVec)) {
            return entityResult;
        }
        return blockResult;
    }
}

