/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.threetag.threecore.ability.Ability;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@OnlyIn(value=Dist.CLIENT)
public class RenderUtil {
    public static float renderTickTime;
    private static float lastBrightnessX;
    private static float lastBrightnessY;
    private static LivingEntity currentEntityInItemRendering;
    private static Ability currentAbilityInIconRendering;

    public static void onRenderGlobal(TickEvent.RenderTickEvent e) {
        renderTickTime = e.renderTickTime;
    }

    public static void setLightmapTextureCoords(float x, float y) {
        lastBrightnessX = GLX.lastBrightnessX;
        lastBrightnessY = GLX.lastBrightnessY;
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)x, (float)y);
    }

    public static void restoreLightmapTextureCoords() {
        GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lastBrightnessX, (float)lastBrightnessY);
    }

    public static void setCurrentEntityInItemRendering(LivingEntity entity) {
        currentEntityInItemRendering = entity;
    }

    @Nullable
    public static LivingEntity getCurrentEntityInItemRendering() {
        return currentEntityInItemRendering;
    }

    public static void setCurrentAbilityInIconRendering(Ability ability) {
        currentAbilityInIconRendering = ability;
    }

    public static Ability getCurrentAbilityInIconRendering() {
        return currentAbilityInIconRendering;
    }

    public static void drawSelectionBoundingBox(AxisAlignedBB box, float red, float green, float blue, float alpha) {
        RenderUtil.drawBoundingBox(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, red, green, blue, alpha);
    }

    public static void drawBoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        RenderUtil.drawBoundingBox(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        tessellator.func_78381_a();
    }

    public static void drawBoundingBox(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, alpha).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_181666_a(red, green, blue, 0.0f).func_181675_d();
    }

    public static void renderFilledBox(AxisAlignedBB aabb, float red, float green, float blue, float alpha) {
        RenderUtil.renderFilledBox(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f, red, green, blue, alpha);
    }

    public static void renderFilledBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        RenderUtil.addChainedFilledBoxVertices(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, red, green, blue, alpha);
        tessellator.func_78381_a();
    }

    public static void addChainedFilledBoxVertices(BufferBuilder builder, double x1, double y1, double z1, double x2, double y2, double z2, float red, float green, float blue, float alpha) {
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y1, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x1, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z1).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
        builder.func_181662_b(x2, y2, z2).func_181666_a(red, green, blue, alpha).func_181675_d();
    }

    public static void renderGuiTank(IFluidHandler fluidHandler, int tank, double x, double y, double zLevel, double width, double height) {
        FluidStack stack = fluidHandler.getFluidInTank(tank);
        int tankCapacity = fluidHandler.getTankCapacity(tank);
        RenderUtil.renderGuiTank(stack, tankCapacity, x, y, zLevel, width, height);
    }

    public static void renderGuiTank(FluidStack stack, int tankCapacity, double x, double y, double zLevel, double width, double height) {
        int amount = stack.getAmount();
        if (stack.getFluid() == null || amount <= 0) {
            return;
        }
        ResourceLocation stillTexture = stack.getFluid().getAttributes().getStillTexture();
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_195424_a(stillTexture);
        int renderAmount = (int)Math.max(Math.min(height, (double)amount * height / (double)tankCapacity), 1.0);
        int posY = (int)(y + height - (double)renderAmount);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        RenderUtil.setColorRGBA(stack.getFluid().getAttributes().getColor(stack));
        GlStateManager.enableBlend();
        int i = 0;
        while ((double)i < width) {
            for (int j = 0; j < renderAmount; j += 16) {
                int drawWidth = (int)Math.min(width - (double)i, 16.0);
                int drawHeight = Math.min(renderAmount - j, 16);
                int drawX = (int)(x + (double)i);
                int drawY = posY + j;
                double minU = icon.func_94209_e();
                double maxU = icon.func_94212_f();
                double minV = icon.func_94206_g();
                double maxV = icon.func_94210_h();
                double u = minU + (maxU - minU) * (double)drawWidth / 16.0;
                double v = minV + (maxV - minV) * (double)drawHeight / 16.0;
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder tes = tessellator.func_178180_c();
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                tes.func_181662_b((double)drawX, (double)(drawY + drawHeight), zLevel).func_187315_a(minU, v).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)(drawY + drawHeight), zLevel).func_187315_a(u, v).func_181675_d();
                tes.func_181662_b((double)(drawX + drawWidth), (double)drawY, zLevel).func_187315_a(u, minV).func_181675_d();
                tes.func_181662_b((double)drawX, (double)drawY, zLevel).func_187315_a(minU, minV).func_181675_d();
                tessellator.func_78381_a();
            }
            i += 16;
        }
        GlStateManager.disableBlend();
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLine(float width, float length) {
        RenderUtil.drawLine(width, length, true, true);
    }

    public static void drawLine(float width, float length, boolean drawTop, boolean drawBottom) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bb = tessellator.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bb.func_181662_b((double)width, 0.0, (double)(-width)).func_181675_d();
        bb.func_181662_b((double)width, (double)length, (double)(-width)).func_181675_d();
        bb.func_181662_b((double)width, (double)length, (double)width).func_181675_d();
        bb.func_181662_b((double)width, 0.0, (double)width).func_181675_d();
        bb.func_181662_b((double)(-width), 0.0, (double)(-width)).func_181675_d();
        bb.func_181662_b((double)(-width), (double)length, (double)(-width)).func_181675_d();
        bb.func_181662_b((double)(-width), (double)length, (double)width).func_181675_d();
        bb.func_181662_b((double)(-width), 0.0, (double)width).func_181675_d();
        bb.func_181662_b((double)(-width), 0.0, (double)width).func_181675_d();
        bb.func_181662_b((double)(-width), (double)length, (double)width).func_181675_d();
        bb.func_181662_b((double)width, (double)length, (double)width).func_181675_d();
        bb.func_181662_b((double)width, 0.0, (double)width).func_181675_d();
        bb.func_181662_b((double)(-width), 0.0, (double)(-width)).func_181675_d();
        bb.func_181662_b((double)(-width), (double)length, (double)(-width)).func_181675_d();
        bb.func_181662_b((double)width, (double)length, (double)(-width)).func_181675_d();
        bb.func_181662_b((double)width, 0.0, (double)(-width)).func_181675_d();
        if (drawTop) {
            bb.func_181662_b((double)(-width), (double)length, (double)(-width)).func_181675_d();
            bb.func_181662_b((double)width, (double)length, (double)(-width)).func_181675_d();
            bb.func_181662_b((double)width, (double)length, (double)width).func_181675_d();
            bb.func_181662_b((double)(-width), (double)length, (double)width).func_181675_d();
        }
        if (drawBottom) {
            bb.func_181662_b((double)(-width), 0.0, (double)(-width)).func_181675_d();
            bb.func_181662_b((double)width, 0.0, (double)(-width)).func_181675_d();
            bb.func_181662_b((double)width, 0.0, (double)width).func_181675_d();
            bb.func_181662_b((double)(-width), 0.0, (double)width).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void drawGlowingLine(float width, float length, Color color, boolean extendedEnd, boolean drawTop, boolean drawBottom) {
        GL11.glPushAttrib((int)64);
        GlStateManager.disableTexture();
        GlStateManager.disableCull();
        RenderHelper.func_74518_a();
        RenderUtil.setLightmapTextureCoords(240.0f, 240.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GL14.glBlendEquation((int)32774);
        float alpha = (float)color.getAlpha() / 255.0f;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderUtil.drawLine(width, length);
        for (int i = 1; i < 3; ++i) {
            GlStateManager.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)(1.0f / (float)i / 2.0f * alpha));
            float growWidth = width + (float)i * 0.5f * 0.0625f;
            float growHeight = extendedEnd ? length + (float)i * 0.5f * 0.0625f : length;
            RenderUtil.drawLine(growWidth, growHeight, drawTop, drawBottom);
        }
        GL14.glBlendEquation((int)32774);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderUtil.restoreLightmapTextureCoords();
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.enableTexture();
    }

    public static void setColorRGBA(int color) {
        float a = (float)RenderUtil.alpha(color) / 255.0f;
        float r = (float)RenderUtil.red(color) / 255.0f;
        float g = (float)RenderUtil.green(color) / 255.0f;
        float b = (float)RenderUtil.blue(color) / 255.0f;
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    static {
        lastBrightnessX = GLX.lastBrightnessX;
        lastBrightnessY = GLX.lastBrightnessY;
        currentEntityInItemRendering = null;
        currentAbilityInIconRendering = null;
    }
}

