/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.threetag.threecore.ThreeCore;

@Mod.EventBusSubscriber(modid="threecore")
public class SupporterHandler {
    private static final String SUPPORTER_FILE = "https://drive.google.com/uc?export=download&id=19iN_yzXWHhn5SfM5GJ-Q1ST5bOtFe8fE";
    private static Map<UUID, SupporterData> REGISTRY = Maps.newHashMap();
    private static boolean CHECK = false;

    public static void load() {
        try {
            JsonObject json = SupporterHandler.readJsonFromUrl(SUPPORTER_FILE);
            JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)"supporters");
            for (int i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                UUID uuid = UUID.fromString(JSONUtils.func_151200_h((JsonObject)obj, (String)"uuid"));
                String name = JSONUtils.func_151200_h((JsonObject)obj, (String)"name");
                CompoundNBT nbt = JsonToNBT.func_180713_a((String)obj.toString());
                SupporterData data = new SupporterData(uuid, name, JSONUtils.func_151209_a((JsonObject)obj, (String)"access", (boolean)false), nbt);
                REGISTRY.put(uuid, data);
            }
            ThreeCore.LOGGER.info("Successfully read supporter information file!");
        }
        catch (Exception e) {
            ThreeCore.LOGGER.error("Was not able to read supporter information file!");
            e.printStackTrace();
            SupporterHandler.addDefaultData();
            ThreeCore.LOGGER.error("Loaded default supporter data!");
        }
    }

    private static void addDefaultData() {
        REGISTRY.put(UUID.fromString("0669d99d-b34d-40fc-a4d8-c7ee963cc842"), new SupporterData(UUID.fromString("0669d99d-b34d-40fc-a4d8-c7ee963cc842"), "TheLucraft", true, new CompoundNBT()));
        REGISTRY.put(UUID.fromString("70e36bc3-f6d5-406b-924c-46d5c5f52101"), new SupporterData(UUID.fromString("70e36bc3-f6d5-406b-924c-46d5c5f52101"), "Neon", true, new CompoundNBT()));
        REGISTRY.put(UUID.fromString("3fa3dc7d-3de2-4ba1-a0ca-adc57bf0827d"), new SupporterData(UUID.fromString("3fa3dc7d-3de2-4ba1-a0ca-adc57bf0827d"), "Sheriff", true, new CompoundNBT()));
        REGISTRY.put(UUID.fromString("fa396f29-9e23-479b-93a5-43e0780f1453"), new SupporterData(UUID.fromString("fa396f29-9e23-479b-93a5-43e0780f1453"), "Nictogen", true, new CompoundNBT()));
        REGISTRY.put(UUID.fromString("7400ab2f-0980-453a-a945-0bafe6cba8cc"), new SupporterData(UUID.fromString("7400ab2f-0980-453a-a945-0bafe6cba8cc"), "Spyeedy", true, new CompoundNBT()));
        REGISTRY.put(UUID.fromString("13b07ab0-663e-456d-98fa-debdb8a3777b"), new SupporterData(UUID.fromString("13b07ab0-663e-456d-98fa-debdb8a3777b"), "HydroSimp", true, new CompoundNBT()));
        REGISTRY.put(UUID.fromString("bc8b891e-5c25-4c9f-ae61-cdfb270f1cc1"), new SupporterData(UUID.fromString("bc8b891e-5c25-4c9f-ae61-cdfb270f1cc1"), "Suffril", true, new CompoundNBT()));
        REGISTRY.put(UUID.fromString("ab572785-66d7-4f5f-b9d4-2a3a68fb9d1a"), new SupporterData(UUID.fromString("ab572785-66d7-4f5f-b9d4-2a3a68fb9d1a"), "Honeyluck", true, new CompoundNBT()));
    }

    public static void enableSupporterCheck() {
        if (!CHECK) {
            CHECK = true;
            ThreeCore.LOGGER.info("The supporter check has been enabled!");
        }
    }

    public static SupporterData getSupporterData(PlayerEntity player) {
        if (REGISTRY.containsKey(player.func_146103_bH().getId())) {
            return REGISTRY.get(player.func_146103_bH().getId());
        }
        return null;
    }

    public static SupporterData getSupporterData(UUID uuid) {
        return REGISTRY.get(uuid);
    }

    public static List<UUID> getUUIDs() {
        return ImmutableList.copyOf(REGISTRY.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject readJsonFromUrl(String url) throws IOException {
        try (InputStream is = new URL(url).openStream();){
            JsonObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            JsonObject jsonObject = json = new JsonParser().parse((Reader)rd).getAsJsonObject();
            return jsonObject;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onWorldJoin(EntityJoinWorldEvent e) {
        if (CHECK && e.getEntity() == Minecraft.func_71410_x().field_71439_g && (SupporterHandler.getSupporterData((PlayerEntity)Minecraft.func_71410_x().field_71439_g) == null || !SupporterHandler.getSupporterData((PlayerEntity)Minecraft.func_71410_x().field_71439_g).modAccess)) {
            throw new RuntimeException("You are not allowed to play this version of the mod!");
        }
    }

    public static class SupporterData {
        protected UUID owner;
        protected String name;
        protected boolean modAccess;
        protected CompoundNBT nbt;

        public SupporterData(UUID owner, String name, boolean modAccess, CompoundNBT nbt) {
            this.owner = owner;
            this.name = name;
            this.modAccess = modAccess;
            this.nbt = nbt;
        }

        public UUID getOwner() {
            return this.owner;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasModAccess() {
            return this.modAccess;
        }

        public CompoundNBT getNbt() {
            return this.nbt;
        }
    }
}

