/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.entityeffect;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import net.threetag.threecore.entity.TCEntityTypes;
import net.threetag.threecore.util.EntityUtil;
import net.threetag.threecore.util.entityeffect.EntityEffect;
import net.threetag.threecore.util.entityeffect.EntityEffectType;

public class EffectEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public UUID anchorUUID;
    public EntityEffect entityEffect;

    public EffectEntity(EntityType<? extends EffectEntity> entityType, World world) {
        super(entityType, world);
        this.field_70158_ak = true;
    }

    public EffectEntity(World worldIn, Entity anchor, EntityEffect entityEffect) {
        this((EntityType<? extends EffectEntity>)((EntityType)TCEntityTypes.EFFECT.get()), worldIn);
        this.anchorUUID = anchor.func_110124_au();
        this.entityEffect = entityEffect;
        this.entityEffect.effectEntity = this;
        this.func_70012_b(anchor.field_70165_t, anchor.field_70163_u + anchor.func_70033_W() + (double)anchor.func_70047_e(), anchor.field_70161_v, anchor.field_70177_z, anchor.field_70125_A);
    }

    protected void func_70088_a() {
    }

    public Entity getAnchorEntity() {
        return EntityUtil.getEntityByUUID(this.field_70170_p, this.anchorUUID);
    }

    public void func_70071_h_() {
        Entity anchor = this.getAnchorEntity();
        if (anchor != null && this.entityEffect != null) {
            if (!anchor.func_70089_S() || this.entityEffect.isDonePlaying()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
            } else {
                this.entityEffect.tick(this, anchor);
                this.func_70012_b(anchor.field_70165_t, anchor.field_70163_u + anchor.func_70033_W() + (double)anchor.func_70047_e(), anchor.field_70161_v, anchor.field_70177_z, anchor.field_70125_A);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("AnchorUUID")) {
            this.anchorUUID = compound.func_186857_a("AnchorUUID");
        }
        this.entityEffect = ((EntityEffectType)EntityEffectType.REGISTRY.getValue(new ResourceLocation(compound.func_74779_i("EffectType")))).create(compound.func_74775_l("EffectData"));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_186854_a("AnchorUUID", this.anchorUUID);
        compound.func_74778_a("EffectType", this.entityEffect.getEntityEffectType().getRegistryName().toString());
        compound.func_218657_a("EffectData", (INBT)this.entityEffect.serializeNBT());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public boolean func_70112_a(double distance) {
        return this.getAnchorEntity() != null && this.entityEffect.isInRangeToRenderDist(this, this.getAnchorEntity(), distance);
    }

    public boolean func_70027_ad() {
        return false;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        CompoundNBT compound = new CompoundNBT();
        this.func_213281_b(compound);
        buffer.func_150786_a(compound);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.func_70037_a(additionalData.func_150793_b());
    }
}

