/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.util.threedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.threetag.threecore.util.threedata.ThreeData;

public class BlockThreeData
extends ThreeData<Block> {
    public BlockThreeData(String key) {
        super(key);
    }

    @Override
    public Block parseValue(JsonObject jsonObject, Block defaultValue) {
        if (!JSONUtils.func_151204_g((JsonObject)jsonObject, (String)this.jsonKey)) {
            return defaultValue;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey)));
        if (block == null) {
            throw new JsonSyntaxException("Block " + JSONUtils.func_151200_h((JsonObject)jsonObject, (String)this.jsonKey) + " does not exist!");
        }
        return block;
    }

    @Override
    public void writeToNBT(CompoundNBT nbt, Block value) {
        nbt.func_74778_a(this.key, Objects.requireNonNull(value.getRegistryName()).toString());
    }

    @Override
    public Block readFromNBT(CompoundNBT nbt, Block defaultValue) {
        if (!nbt.func_74764_b(this.key)) {
            return defaultValue;
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.func_74779_i(this.key)));
    }

    @Override
    public JsonElement serializeJson(Block value) {
        return new JsonPrimitive(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)value).toString());
    }
}

