function initializeCoreMod() {

    Opcodes = Java.type("org.objectweb.asm.Opcodes");

    MethodInsnNode = Java.type("org.objectweb.asm.tree.MethodInsnNode");

    INVOKESTATIC = Opcodes.INVOKESTATIC;
    INVOKEVIRTUAL = Opcodes.INVOKEVIRTUAL;

    return {
        'FirstPersonRenderer#renderArm': {
            'target': {
                'type': 'METHOD',
                'class': 'net.minecraft.client.renderer.FirstPersonRenderer',
                'methodName': 'func_187456_a',
                'methodDesc': '(FFLnet/minecraft/util/HandSide;)V'
            },
            'transformer': function (methodNode) {
                var instructions = methodNode.instructions;
                var injectionPoint1 = null;
                var injectionPoint2 = null;
                var renderRightArm_name = 'renderRightArm';
                var renderLeftArm_name = 'renderLeftArm';

                for (var i = 0; i < instructions.size(); i++) {
                    var instruction = instructions.get(i);

                    if (instruction.getOpcode() == INVOKEVIRTUAL) {
                        if (instruction.name == renderRightArm_name) {
                            injectionPoint1 = instructions.get(i);
                        } else if (instruction.name == renderLeftArm_name) {
                            injectionPoint2 = instructions.get(i);
                        }
                    }
                }

                instructions.set(injectionPoint1, new MethodInsnNode(
                    //int opcode
                    INVOKESTATIC,
                    //String owner
                    "net/threetag/threecore/client/renderer/entity/PlayerHandRenderer",
                    //String name
                    "renderRightArm",
                    //String descriptor
                    "(Lnet/minecraft/client/renderer/entity/PlayerRenderer;Lnet/minecraft/client/entity/player/AbstractClientPlayerEntity;)V",
                    //boolean isInterface
                    false
                ));

                instructions.set(injectionPoint2, new MethodInsnNode(
                    //int opcode
                    INVOKESTATIC,
                    //String owner
                    "net/threetag/threecore/client/renderer/entity/PlayerHandRenderer",
                    //String name
                    "renderLeftArm",
                    //String descriptor
                    "(Lnet/minecraft/client/renderer/entity/PlayerRenderer;Lnet/minecraft/client/entity/player/AbstractClientPlayerEntity;)V",
                    //boolean isInterface
                    false
                ));

                return methodNode;
            }
        }
    }
}
