/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.data.IDataProvider;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.threetag.pymtech.ability.PTAbilityTypes;
import net.threetag.pymtech.block.PTBlocks;
import net.threetag.pymtech.client.gui.RegulatorTier1Screen;
import net.threetag.pymtech.client.gui.RegulatorTier2Screen;
import net.threetag.pymtech.client.gui.RegulatorTier3Screen;
import net.threetag.pymtech.client.gui.StructureShrinkerScreen;
import net.threetag.pymtech.client.renderer.entity.model.WaspWingsModel;
import net.threetag.pymtech.client.renderer.model.ShrunkenStructureBakedModel;
import net.threetag.pymtech.client.renderer.tileentity.StructureShrinkerTileEntityRenderer;
import net.threetag.pymtech.config.PTServerConfig;
import net.threetag.pymtech.container.PTContainerTypes;
import net.threetag.pymtech.container.PymParticleVialSlot;
import net.threetag.pymtech.container.RegulatorSlot;
import net.threetag.pymtech.data.PTItemTagsProvider;
import net.threetag.pymtech.data.PTLangProvider;
import net.threetag.pymtech.data.PTLootTableProvider;
import net.threetag.pymtech.data.PTRecipeProvider;
import net.threetag.pymtech.item.PTItems;
import net.threetag.pymtech.network.NotifyShrunkenStructureUpdate;
import net.threetag.pymtech.network.RequestShrunkenStructureMessage;
import net.threetag.pymtech.network.SetRegulatedSizeMessage;
import net.threetag.pymtech.network.StructureShrinkActivateMessage;
import net.threetag.pymtech.network.SyncShrunkenStructureMessage;
import net.threetag.pymtech.sound.PTSoundEvents;
import net.threetag.threecore.client.renderer.entity.model.ModelRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="pymtech")
public class PymTech {
    public static final String MODID = "pymtech";
    private static final Logger LOGGER = LogManager.getLogger();
    public static SimpleChannel NETWORK_CHANNEL;
    private static int networkId;

    public PymTech() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, PTServerConfig.generateConfig());
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        PymTech.registerMessage(SyncShrunkenStructureMessage.class, SyncShrunkenStructureMessage::toBytes, SyncShrunkenStructureMessage::new, SyncShrunkenStructureMessage::handle);
        PymTech.registerMessage(RequestShrunkenStructureMessage.class, RequestShrunkenStructureMessage::toBytes, RequestShrunkenStructureMessage::new, RequestShrunkenStructureMessage::handle);
        PymTech.registerMessage(StructureShrinkActivateMessage.class, StructureShrinkActivateMessage::toBytes, StructureShrinkActivateMessage::new, StructureShrinkActivateMessage::handle);
        PymTech.registerMessage(NotifyShrunkenStructureUpdate.class, NotifyShrunkenStructureUpdate::toBytes, NotifyShrunkenStructureUpdate::new, NotifyShrunkenStructureUpdate::handle);
        PymTech.registerMessage(SetRegulatedSizeMessage.class, SetRegulatedSizeMessage::toBytes, SetRegulatedSizeMessage::new, SetRegulatedSizeMessage::handle);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void setupClient(FMLClientSetupEvent e) {
        ScreenManager.func_216911_a(PTContainerTypes.STRUCTURE_SHRINKER, StructureShrinkerScreen::new);
        ScreenManager.func_216911_a(PTContainerTypes.REGULATOR_TIER1, RegulatorTier1Screen::new);
        ScreenManager.func_216911_a(PTContainerTypes.REGULATOR_TIER2, RegulatorTier2Screen::new);
        ScreenManager.func_216911_a(PTContainerTypes.REGULATOR_TIER3, RegulatorTier3Screen::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)PTBlocks.STRUCTURE_SHRINKER_TILE_ENTITY.get()), StructureShrinkerTileEntityRenderer::new);
        ModelRegistry.registerModel((String)"pymtech:wasp_wings", new WaspWingsModel(0.0f));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void textureStichPre(TextureStitchEvent.Pre e) {
        e.addSprite(PymParticleVialSlot.OVERLAY_TEXTURE);
        e.addSprite(RegulatorSlot.OVERLAY_TEXTURE);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onModelRegistry(ModelRegistryEvent e) {
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(MODID, "item/shrunken_structure_gui"));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        IBakedModel defaultModel = (IBakedModel)e.getModelRegistry().get(new ModelResourceLocation(new ResourceLocation(MODID, "shrunken_structure"), "inventory"));
        IBakedModel placeholderModel = (IBakedModel)e.getModelRegistry().get(new ResourceLocation(MODID, "item/shrunken_structure_gui"));
        e.getModelRegistry().put(new ModelResourceLocation(new ResourceLocation(MODID, "shrunken_structure"), "inventory"), new ShrunkenStructureBakedModel(defaultModel, placeholderModel));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onNewRegistries(RegistryEvent.NewRegistry e) {
        PTBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        PTBlocks.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        PTItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        PTAbilityTypes.ABILITY_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        PTSoundEvents.SOUND_EVENTS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent e) {
        e.getGenerator().func_200390_a((IDataProvider)new PTRecipeProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new PTItemTagsProvider(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new PTLangProvider.English(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new PTLangProvider.German(e.getGenerator()));
        e.getGenerator().func_200390_a((IDataProvider)new PTLootTableProvider(e.getGenerator()));
    }

    public static <MSG> int registerMessage(Class<MSG> messageType, BiConsumer<MSG, PacketBuffer> encoder, Function<PacketBuffer, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> messageConsumer) {
        if (NETWORK_CHANNEL == null) {
            NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, MODID), () -> "1.0", s -> true, s -> true);
        }
        int id = networkId++;
        NETWORK_CHANNEL.registerMessage(id, messageType, encoder, decoder, messageConsumer);
        return id;
    }

    static {
        networkId = -1;
    }
}

