/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.pymtech.sizechangetype;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.threetag.pymtech.config.PTServerConfig;
import net.threetag.pymtech.entity.DiscoTrailEntity;
import net.threetag.pymtech.entity.attributes.PTAttributes;
import net.threetag.pymtech.sound.PTSoundEvents;
import net.threetag.pymtech.util.PTDamageSources;
import net.threetag.threecore.capability.CapabilitySizeChanging;
import net.threetag.threecore.capability.ISizeChanging;
import net.threetag.threecore.entity.attributes.TCAttributes;
import net.threetag.threecore.potion.TCEffects;
import net.threetag.threecore.sizechanging.DefaultSizeChangeType;
import net.threetag.threecore.sizechanging.SizeChangeType;
import net.threetag.threecore.util.PlayerUtil;

public class PymParticleSizeChangeType
extends DefaultSizeChangeType {
    public int getSizeChangingTime(Entity entity, ISizeChanging iSizeChanging, float size) {
        return 10;
    }

    public void onSizeChanged(final Entity entity, ISizeChanging iSizeChanging, float size) {
        if (entity instanceof LivingEntity) {
            AbstractAttributeMap map = ((LivingEntity)entity).func_110140_aT();
            this.setAttribute(map, SharedMonsterAttributes.field_111263_d, size > 1.0f ? 0.0 : (double)(size - 1.0f) * 0.5, size > 1.0f ? AttributeModifier.Operation.ADDITION : AttributeModifier.Operation.MULTIPLY_TOTAL, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, TCAttributes.SPRINT_SPEED, size == 1.0f ? 0.0 : (size >= 1.0f ? (double)(-0.2f * size) : (double)(size - 1.0f) * 0.5), size >= 1.0f ? AttributeModifier.Operation.ADDITION : AttributeModifier.Operation.MULTIPLY_TOTAL, SizeChangeType.ATTRIBUTE_UUID);
            if (((LivingEntity)entity).func_110140_aT().func_111151_a(TCAttributes.SPRINT_SPEED) != null && size == 1.0f) {
                ((LivingEntity)entity).func_110148_a(TCAttributes.SPRINT_SPEED).func_188479_b(SizeChangeType.ATTRIBUTE_UUID);
            }
            this.setAttribute(map, TCAttributes.JUMP_HEIGHT, size > 1.0f ? (double)(size - 1.0f) * 1.0 : (double)(size == 1.0f ? 0.0f : size), AttributeModifier.Operation.ADDITION, ATTRIBUTE_UUID);
            this.setAttribute(map, TCAttributes.FALL_RESISTANCE, size > 1.0f ? (double)(1.0f / size) : (double)(size / 2.0f), AttributeModifier.Operation.MULTIPLY_TOTAL, ATTRIBUTE_UUID);
            this.setAttribute(map, SharedMonsterAttributes.field_111264_e, size > 1.0f ? (double)(size - 1.0f) * 3.0 : (double)(size == 1.0f ? 0.0f : (1.0f - size) * 2.0f), AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, SharedMonsterAttributes.field_188790_f, size > 1.0f ? (double)(size / 2.0f + 1.0f) : 0.0, AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            if (((LivingEntity)entity).func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188790_f) != null && size <= 1.0f) {
                ((LivingEntity)entity).func_110148_a(SharedMonsterAttributes.field_188790_f).func_188479_b(SizeChangeType.ATTRIBUTE_UUID);
            }
            this.setAttribute(map, PlayerEntity.REACH_DISTANCE, (double)(size - 1.0f) * 1.0, AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            this.setAttribute(map, SharedMonsterAttributes.field_111266_c, size < 0.5f ? (double)(size - 1.0f) * 20.0 : (double)(size - 1.0f) * 0.5, AttributeModifier.Operation.ADDITION, SizeChangeType.ATTRIBUTE_UUID);
            if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 2 == 0) {
                DiscoTrailEntity discoTrail = new DiscoTrailEntity(entity.field_70170_p, (LivingEntity)entity, 10);
                float scale = ((ISizeChanging)entity.getCapability(CapabilitySizeChanging.SIZE_CHANGING).orElse((Object)new CapabilitySizeChanging(entity))).getScale();
                ((ISizeChanging)discoTrail.getCapability(CapabilitySizeChanging.SIZE_CHANGING).orElse((Object)new CapabilitySizeChanging((Entity)discoTrail))).setSizeDirectly(SizeChangeType.DEFAULT_TYPE, scale);
                entity.field_70170_p.func_217376_c((Entity)discoTrail);
            }
            this.changeCreeperExplosionRadius(entity, size);
            this.spawnWaterParticles(entity);
            if (size < 5.0f) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        if (Minecraft.func_71410_x().field_71439_g == entity) {
                            Minecraft.func_71410_x().field_71474_y.field_74326_T = false;
                        }
                    }
                });
            }
        }
    }

    public void onUpdate(final Entity entity, ISizeChanging data, float size) {
        if (size < 0.4f && entity.field_70173_aa % 50 == 0) {
            entity.func_70097_a(PTDamageSources.PYM_PARTICLE_SUFFOCATE, 6.0f);
        }
        if (size >= 5.0f) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    if (Minecraft.func_71410_x().field_71439_g == entity) {
                        Minecraft.func_71410_x().field_71474_y.field_74326_T = true;
                    }
                }
            });
        }
        if (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_()) {
            String nbtKey = "pymtech:size_resistance_timer";
            if (entity instanceof LivingEntity && !entity.field_70170_p.field_72995_K) {
                if (size > 2.0f && ((Boolean)PTServerConfig.PASSING_OUT_WHEN_GIANT.get()).booleanValue()) {
                    int timer = (int)((float)entity.getPersistentData().func_74762_e(nbtKey) + size);
                    entity.getPersistentData().func_74768_a(nbtKey, timer);
                    int max = (int)(1000.0 + ((LivingEntity)entity).func_110148_a(PTAttributes.SIZE_RESISTANCE).func_111126_e() * 10.0);
                    if (((Boolean)PTServerConfig.HUNGER.get()).booleanValue()) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76438_s, 55, 1, false, false));
                    }
                    if ((double)timer >= (double)max * 0.7 && entity.field_70173_aa % 100 == 0) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance((Effect)TCEffects.UNCONSCIOUS.get(), 25, 0, false, false));
                    }
                    if (timer >= max) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance((Effect)TCEffects.UNCONSCIOUS.get(), 60, 0, false, false));
                        if (timer >= max + 500) {
                            data.startSizeChange((SizeChangeType)this, 1.0f);
                        }
                    }
                } else if (size < 0.5f && ((Boolean)PTServerConfig.NAUSEA_WHEN_SMALL.get()).booleanValue()) {
                    int timer = (int)((float)entity.getPersistentData().func_74762_e(nbtKey) + 1.0f / size);
                    entity.getPersistentData().func_74768_a(nbtKey, timer);
                    int max = (int)(1000.0 + ((LivingEntity)entity).func_110148_a(PTAttributes.SIZE_RESISTANCE).func_111126_e() * 30.0);
                    if (((Boolean)PTServerConfig.HUNGER.get()).booleanValue()) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76438_s, 55, 1, false, false));
                    }
                    if ((double)timer >= (double)max * 0.7 && entity.field_70173_aa % 300 == 0) {
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76431_k, 200, 0, false, false));
                        ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76438_s, 10, 0, false, false));
                    }
                } else if (entity.getPersistentData().func_74762_e(nbtKey) > 0) {
                    entity.getPersistentData().func_74768_a(nbtKey, 0);
                }
            } else if (entity.getPersistentData().func_74762_e(nbtKey) > 0) {
                entity.getPersistentData().func_74768_a(nbtKey, 0);
            }
        }
    }

    public boolean start(Entity entity, ISizeChanging data, float size, float estimatedSize) {
        SoundEvent soundEvent = estimatedSize < size ? (entity.func_70090_H() ? (SoundEvent)PTSoundEvents.SHRINK_UNDERWATER.get() : (SoundEvent)PTSoundEvents.SHRINK.get()) : (entity.func_70090_H() ? (SoundEvent)PTSoundEvents.ENLARGE_UNDERWATER.get() : (SoundEvent)PTSoundEvents.ENLARGE.get());
        PlayerUtil.playSoundToAll((World)entity.field_70170_p, (double)entity.func_226277_ct_(), (double)(entity.func_226278_cu_() + (double)entity.field_213325_aI.field_220316_b / 2.0), (double)entity.func_226281_cx_(), (double)50.0, (SoundEvent)soundEvent, (SoundCategory)SoundCategory.PLAYERS);
        return true;
    }

    public void end(Entity entity, ISizeChanging iSizeChanging, float size) {
    }
}

