/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityType;
import net.threetag.threecore.util.icon.ItemIcon;
import net.threetag.threecore.util.threedata.BooleanThreeData;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.IntegerThreeData;
import net.threetag.threecore.util.threedata.StringThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class OpeningNbtTimerAbility
extends Ability {
    public static final ThreeData<Integer> MAX = new IntegerThreeData("max_timer").setSyncType(EnumSync.NONE).enableSetting("Sets the maximum value for the timer, there it goes from 0 to this value-1. You define it in ticks (20 ticks = 1 second).");
    public static final ThreeData<String> NBT_TAG = new StringThreeData("nbt_tag").setSyncType(EnumSync.NONE).enableSetting("Determines the nbt tag in the item which will be used.");
    public static final ThreeData<Boolean> OPEN = new BooleanThreeData("open").setSyncType(EnumSync.NONE);

    public OpeningNbtTimerAbility() {
        super(AbilityType.OPENING_NBT_TIMER);
    }

    @Override
    public void registerData() {
        super.registerData();
        this.dataManager.register(ICON, new ItemIcon(new ItemStack((IItemProvider)Items.field_151028_Y)));
        this.dataManager.register((ThreeData)MAX, (Object)10);
        this.dataManager.register((ThreeData)NBT_TAG, "Opening");
        this.dataManager.register((ThreeData)OPEN, (Object)false);
    }

    @Override
    public void action(LivingEntity entity) {
        this.dataManager.set((ThreeData)OPEN, (Object)(this.dataManager.get(OPEN) == false ? 1 : 0));
    }

    @Override
    public void tick(LivingEntity entity) {
        super.tick(entity);
        if (!entity.field_70170_p.field_72995_K && this.container.getNbtTag(entity) != null) {
            CompoundNBT nbt = this.container.getNbtTag(entity);
            String tag = this.dataManager.get(NBT_TAG);
            int timer = nbt.func_74762_e(tag);
            int maxTimer = this.dataManager.get(MAX);
            boolean open = this.dataManager.get(OPEN);
            if (open && timer < maxTimer) {
                nbt.func_74768_a(tag, timer + 1);
            } else if (!open && timer > 0) {
                nbt.func_74768_a(tag, timer - 1);
            }
        }
    }
}

