/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.ability.condition;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.crafting.Ingredient;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.ability.condition.ConditionType;
import net.threetag.threecore.util.threedata.EnumSync;
import net.threetag.threecore.util.threedata.IngredientThreeData;
import net.threetag.threecore.util.threedata.ThreeData;

public class WearingItemCondition
extends Condition {
    public static final Map<EquipmentSlotType, ThreeData<Ingredient>> SLOT_DATA = Maps.newHashMap();

    public WearingItemCondition(Ability ability) {
        super(ConditionType.WEARING_ITEM, ability);
    }

    @Override
    public void registerData() {
        super.registerData();
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            this.dataManager.register((ThreeData)SLOT_DATA.get(slot), Ingredient.field_193370_a);
        }
    }

    @Override
    public boolean test(LivingEntity entity) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            Ingredient ingredient = this.dataManager.get(SLOT_DATA.get(slot));
            if (ingredient == Ingredient.field_193370_a || ingredient.test(entity.func_184582_a(slot))) continue;
            return false;
        }
        return true;
    }

    static {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            SLOT_DATA.put(slot, new IngredientThreeData(slot.func_188450_d().toLowerCase()).setSyncType(EnumSync.SELF).enableSetting("Specifies the ingredient for the item in the " + slot.func_188450_d() + " slot"));
        }
    }
}

