/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.tileentity.CapacitorBlockTileEntity;
import net.threetag.threecore.util.BlockUtil;
import net.threetag.threecore.util.energy.IEnergyConfig;

public class CapacitorBlock
extends ContainerBlock {
    public static final IntegerProperty LEVEL_0_10 = IntegerProperty.func_177719_a((String)"level", (int)0, (int)10);
    private final Type type;

    public CapacitorBlock(Block.Properties properties, Type type) {
        super(properties);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)LEVEL_0_10, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CapacitorBlockTileEntity(this.type);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public int func_149750_m(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)LEVEL_0_10);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof CapacitorBlockTileEntity) {
            if (stack.func_82837_s()) {
                ((LockableTileEntity)tileEntity).func_213903_a(stack.func_200301_q());
            }
            ((CapacitorBlockTileEntity)tileEntity).energyStorage.setEnergyStored(stack.func_196082_o().func_74762_e("Energy"));
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity != null) {
                tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(i -> BlockUtil.dropInventoryItems(worldIn, pos, i));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)LEVEL_0_10);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LEVEL_0_10});
    }

    public static enum Type implements IStringSerializable
    {
        NORMAL("normal", ThreeCoreServerConfig.ENERGY.CAPACITOR),
        ADVANCED("advanced", ThreeCoreServerConfig.ENERGY.ADVANCED_CAPACITOR);

        private final String name;
        private final IEnergyConfig energyConfig;

        private Type(String name, IEnergyConfig energyConfig) {
            this.name = name;
            this.energyConfig = energyConfig;
        }

        public String func_176610_l() {
            return this.name;
        }

        public IEnergyConfig getEnergyConfig() {
            return this.energyConfig;
        }

        public static Type getByName(String name) {
            for (Type type : Type.values()) {
                if (!type.func_176610_l().equalsIgnoreCase(name)) continue;
                return type;
            }
            return Type.values()[0];
        }
    }
}

