/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.block.MachineBlock;
import net.threetag.threecore.tileentity.StirlingGeneratorTileEntity;

public class StirlingGeneratorBlock
extends MachineBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final VoxelShape INSIDE = StirlingGeneratorBlock.func_208617_a((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    public static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)INSIDE, (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public StirlingGeneratorBlock(Block.Properties builder) {
        super(builder);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new StirlingGeneratorTileEntity();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = pos.func_177956_o();
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                for (int i = 0; i < 4; ++i) {
                    double x = (double)pos.func_177958_n() + 0.5 + rand.nextDouble() * 0.6 - 0.3;
                    double y = (double)pos.func_177956_o() + 0.4;
                    double z = (double)pos.func_177952_p() + 0.5 + rand.nextDouble() * 0.6 - 0.3;
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_218417_ae, x, y, z, 0.0, 0.1, 0.0);
                }
            }
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_219619_am, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.func_177229_b((IProperty)FACING);
            Direction.Axis direction$axis = direction.func_176740_k();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.func_82601_c() * d3 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.func_82599_e() * d3 : d4;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader blockReader, BlockPos pos) {
        return INSIDE;
    }
}

