/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.block;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.threetag.threecore.ThreeCoreCommonConfig;
import net.threetag.threecore.ThreeCoreServerConfig;
import net.threetag.threecore.block.CapacitorBlock;
import net.threetag.threecore.block.ConstructionTableBlock;
import net.threetag.threecore.block.EnergyConduitBlock;
import net.threetag.threecore.block.FluidComposerBlock;
import net.threetag.threecore.block.GrinderBlock;
import net.threetag.threecore.block.HydraulicPressBlock;
import net.threetag.threecore.block.SolarPanelBlock;
import net.threetag.threecore.block.StirlingGeneratorBlock;
import net.threetag.threecore.item.CapacitorBlockItem;
import net.threetag.threecore.item.ItemGroupRegistry;
import net.threetag.threecore.item.TCItems;

public class TCBlocks {
    public static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "threecore");
    public static final RegistryObject<Block> CONSTRUCTION_TABLE = TCBlocks.register("construction_table", () -> new ConstructionTableBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)), ItemGroup.field_78031_c);
    public static final RegistryObject<Block> GRINDER = TCBlocks.register("grinder", () -> new GrinderBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> HYDRAULIC_PRESS = TCBlocks.register("hydraulic_press", () -> new HydraulicPressBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> FLUID_COMPOSER = TCBlocks.register("fluid_composer", () -> new FluidComposerBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> CAPACITOR_BLOCK = BLOCKS.register("capacitor_block", () -> new CapacitorBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f), CapacitorBlock.Type.NORMAL));
    public static final RegistryObject<Item> CAPACITOR_BLOCK_ITEM = TCItems.ITEMS.register("capacitor_block", () -> new CapacitorBlockItem((Block)CAPACITOR_BLOCK.get(), new Item.Properties().func_200917_a(1).func_200916_a(ItemGroupRegistry.getItemGroup("technology")), ThreeCoreServerConfig.ENERGY.CAPACITOR));
    public static final RegistryObject<Block> ADVANCED_CAPACITOR_BLOCK = BLOCKS.register("advanced_capacitor_block", () -> new CapacitorBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f), CapacitorBlock.Type.ADVANCED));
    public static final RegistryObject<Item> ADVANCED_CAPACITOR_BLOCK_ITEM = TCItems.ITEMS.register("advanced_capacitor_block", () -> new CapacitorBlockItem((Block)ADVANCED_CAPACITOR_BLOCK.get(), new Item.Properties().func_200917_a(1).func_200916_a(ItemGroupRegistry.getItemGroup("technology")), ThreeCoreServerConfig.ENERGY.ADVANCED_CAPACITOR));
    public static final RegistryObject<Block> STIRLING_GENERATOR = TCBlocks.register("stirling_generator", () -> new StirlingGeneratorBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200951_a(13).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> SOLAR_PANEL = TCBlocks.register("solar_panel", () -> new SolarPanelBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> GOLD_CONDUIT = TCBlocks.register("gold_conduit", () -> new EnergyConduitBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(5.0f, 6.0f), EnergyConduitBlock.ConduitType.GOLD, 0.125f), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> COPPER_CONDUIT = TCBlocks.register("copper_conduit", () -> new EnergyConduitBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(5.0f, 6.0f), EnergyConduitBlock.ConduitType.COPPER, 0.125f), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> SILVER_CONDUIT = TCBlocks.register("silver_conduit", () -> new EnergyConduitBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(5.0f, 6.0f), EnergyConduitBlock.ConduitType.SILVER, 0.125f), ItemGroupRegistry.getItemGroup("technology"));
    public static final RegistryObject<Block> COPPER_BLOCK = TCBlocks.register("copper_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> TIN_BLOCK = TCBlocks.register("tin_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> LEAD_BLOCK = TCBlocks.register("lead_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(4.0f, 12.0f)));
    public static final RegistryObject<Block> SILVER_BLOCK = TCBlocks.register("silver_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> PALLADIUM_BLOCK = TCBlocks.register("palladium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> VIBRANIUM_BLOCK = TCBlocks.register("vibranium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(15.0f, 18.0f)), Rarity.RARE);
    public static final RegistryObject<Block> OSMIUM_BLOCK = TCBlocks.register("osmium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> URANIUM_BLOCK = TCBlocks.register("uranium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> TITANIUM_BLOCK = TCBlocks.register("titanium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(10.0f, 12.0f)));
    public static final RegistryObject<Block> IRIDIUM_BLOCK = TCBlocks.register("iridium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(10.0f, 15.0f)), Rarity.UNCOMMON);
    public static final RegistryObject<Block> URU_BLOCK = TCBlocks.register("uru_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(10.0f, 15.0f)), Rarity.EPIC);
    public static final RegistryObject<Block> BRONZE_BLOCK = TCBlocks.register("bronze_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> INTERTIUM_BLOCK = TCBlocks.register("intertium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> STEEL_BLOCK = TCBlocks.register("steel_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(5.0f, 6.0f)));
    public static final RegistryObject<Block> GOLD_TITANIUM_ALLOY_BLOCK = TCBlocks.register("gold_titanium_alloy_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(7.0f, 8.0f)));
    public static final RegistryObject<Block> ADAMANTIUM_BLOCK = TCBlocks.register("adamantium_block", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(15.0f, 18.0f)), Rarity.RARE);
    public static final RegistryObject<Block> COPPER_ORE = TCBlocks.register("copper_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> TIN_ORE = TCBlocks.register("tin_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> LEAD_ORE = TCBlocks.register("lead_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> SILVER_ORE = TCBlocks.register("silver_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> PALLADIUM_ORE = TCBlocks.register("palladium_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> VIBRANIUM_ORE = TCBlocks.register("vibranium_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(3.0f, 5.0f).func_200951_a(4)), Rarity.RARE);
    public static final RegistryObject<Block> OSMIUM_ORE = TCBlocks.register("osmium_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> URANIUM_ORE = TCBlocks.register("uranium_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> TITANIUM_ORE = TCBlocks.register("titanium_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(3.0f, 5.0f)));
    public static final RegistryObject<Block> IRIDIUM_ORE = TCBlocks.register("iridium_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(3.0f, 5.0f)), Rarity.UNCOMMON);
    public static final RegistryObject<Block> URU_ORE = TCBlocks.register("uru_ore", () -> new Block(Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200948_a(3.0f, 5.0f)), Rarity.EPIC);
    public static final RegistryObject<Block> WHITE_CONCRETE_SLAB = TCBlocks.register("white_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196828_iC)));
    public static final RegistryObject<Block> ORANGE_CONCRETE_SLAB = TCBlocks.register("orange_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196830_iD)));
    public static final RegistryObject<Block> MAGENTA_CONCRETE_SLAB = TCBlocks.register("magenta_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196832_iE)));
    public static final RegistryObject<Block> LIGHT_BLUE_CONCRETE_SLAB = TCBlocks.register("light_blue_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196834_iF)));
    public static final RegistryObject<Block> YELLOW_CONCRETE_SLAB = TCBlocks.register("yellow_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196836_iG)));
    public static final RegistryObject<Block> LIME_CONCRETE_SLAB = TCBlocks.register("lime_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196838_iH)));
    public static final RegistryObject<Block> PINK_CONCRETE_SLAB = TCBlocks.register("pink_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196840_iI)));
    public static final RegistryObject<Block> GRAY_CONCRETE_SLAB = TCBlocks.register("gray_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196842_iJ)));
    public static final RegistryObject<Block> LIGHT_GRAY_CONCRETE_SLAB = TCBlocks.register("light_gray_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196844_iK)));
    public static final RegistryObject<Block> CYAN_CONCRETE_SLAB = TCBlocks.register("cyan_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196846_iL)));
    public static final RegistryObject<Block> PURPLE_CONCRETE_SLAB = TCBlocks.register("purple_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196848_iM)));
    public static final RegistryObject<Block> BLUE_CONCRETE_SLAB = TCBlocks.register("blue_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196850_iN)));
    public static final RegistryObject<Block> BROWN_CONCRETE_SLAB = TCBlocks.register("brown_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196852_iO)));
    public static final RegistryObject<Block> GREEN_CONCRETE_SLAB = TCBlocks.register("green_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196854_iP)));
    public static final RegistryObject<Block> RED_CONCRETE_SLAB = TCBlocks.register("red_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196856_iQ)));
    public static final RegistryObject<Block> BLACK_CONCRETE_SLAB = TCBlocks.register("black_concrete_slab", () -> new SlabBlock(Block.Properties.func_200950_a((Block)Blocks.field_196858_iR)));
    public static final RegistryObject<Block> WHITE_CONCRETE_STAIRS = TCBlocks.register("white_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196828_iC).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196828_iC)));
    public static final RegistryObject<Block> ORANGE_CONCRETE_STAIRS = TCBlocks.register("orange_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196830_iD).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196830_iD)));
    public static final RegistryObject<Block> MAGENTA_CONCRETE_STAIRS = TCBlocks.register("magenta_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196832_iE).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196832_iE)));
    public static final RegistryObject<Block> LIGHT_BLUE_CONCRETE_STAIRS = TCBlocks.register("light_blue_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196834_iF).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196834_iF)));
    public static final RegistryObject<Block> YELLOW_CONCRETE_STAIRS = TCBlocks.register("yellow_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196836_iG).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196836_iG)));
    public static final RegistryObject<Block> LIME_CONCRETE_STAIRS = TCBlocks.register("lime_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196838_iH).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196838_iH)));
    public static final RegistryObject<Block> PINK_CONCRETE_STAIRS = TCBlocks.register("pink_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196840_iI).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196840_iI)));
    public static final RegistryObject<Block> GRAY_CONCRETE_STAIRS = TCBlocks.register("gray_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196842_iJ).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196842_iJ)));
    public static final RegistryObject<Block> LIGHT_GRAY_CONCRETE_STAIRS = TCBlocks.register("light_gray_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196844_iK).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196844_iK)));
    public static final RegistryObject<Block> CYAN_CONCRETE_STAIRS = TCBlocks.register("cyan_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196846_iL).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196846_iL)));
    public static final RegistryObject<Block> PURPLE_CONCRETE_STAIRS = TCBlocks.register("purple_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196848_iM).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196848_iM)));
    public static final RegistryObject<Block> BLUE_CONCRETE_STAIRS = TCBlocks.register("blue_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196850_iN).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196850_iN)));
    public static final RegistryObject<Block> BROWN_CONCRETE_STAIRS = TCBlocks.register("brown_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196852_iO).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196852_iO)));
    public static final RegistryObject<Block> GREEN_CONCRETE_STAIRS = TCBlocks.register("green_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196854_iP).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196854_iP)));
    public static final RegistryObject<Block> RED_CONCRETE_STAIRS = TCBlocks.register("red_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196856_iQ).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196856_iQ)));
    public static final RegistryObject<Block> BLACK_CONCRETE_STAIRS = TCBlocks.register("black_concrete_stairs", () -> new StairsBlock(() -> ((Block)Blocks.field_196858_iR).func_176223_P(), Block.Properties.func_200950_a((Block)Blocks.field_196858_iR)));

    public static void initOres() {
        ForgeRegistries.BIOMES.getValues().forEach(b -> {
            TCBlocks.addOreFeature(b, ((Block)COPPER_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.COPPER);
            TCBlocks.addOreFeature(b, ((Block)TIN_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.TIN);
            TCBlocks.addOreFeature(b, ((Block)LEAD_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.LEAD);
            TCBlocks.addOreFeature(b, ((Block)SILVER_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.SILVER);
            TCBlocks.addOreFeature(b, ((Block)PALLADIUM_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.PALLADIUM);
            TCBlocks.addOreFeature(b, ((Block)VIBRANIUM_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.VIBRANIUM);
            TCBlocks.addOreFeature(b, ((Block)OSMIUM_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.OSMIUM);
            TCBlocks.addOreFeature(b, ((Block)URANIUM_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.URANIUM);
            TCBlocks.addOreFeature(b, ((Block)TITANIUM_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.TITANIUM);
            TCBlocks.addOreFeature(b, ((Block)IRIDIUM_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.IRIDIUM);
            TCBlocks.addOreFeature(b, ((Block)URU_ORE.get()).func_176223_P(), ThreeCoreCommonConfig.MATERIALS.URU);
        });
    }

    public static void initRenderTypes() {
        RenderTypeLookup.setRenderLayer((Block)((Block)CONSTRUCTION_TABLE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)GRINDER.get()), (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)((Block)HYDRAULIC_PRESS.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)FLUID_COMPOSER.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)STIRLING_GENERATOR.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)VIBRANIUM_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
    }

    public static void addOreFeature(Biome biome, BlockState ore, ThreeCoreCommonConfig.Materials.OreConfig config) {
        biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ore, ((Integer)config.size.get()).intValue())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(((Integer)config.count.get()).intValue(), ((Integer)config.minHeight.get()).intValue(), 0, (Integer)config.maxHeight.get() - (Integer)config.minHeight.get()))));
    }

    public static <T extends Block> RegistryObject<T> register(String id, Supplier<T> blockSupplier) {
        RegistryObject registryObject = BLOCKS.register(id, blockSupplier);
        TCItems.ITEMS.register(id, () -> new BlockItem((Block)registryObject.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
        return registryObject;
    }

    public static <T extends Block> RegistryObject<T> register(String id, Supplier<T> blockSupplier, Supplier<Item> itemSupplier) {
        RegistryObject registryObject = BLOCKS.register(id, blockSupplier);
        TCItems.ITEMS.register(id, itemSupplier);
        return registryObject;
    }

    public static <T extends Block> RegistryObject<T> register(String id, Supplier<T> blockSupplier, ItemGroup itemGroup) {
        RegistryObject registryObject = BLOCKS.register(id, blockSupplier);
        TCItems.ITEMS.register(id, () -> new BlockItem((Block)registryObject.get(), new Item.Properties().func_200916_a(itemGroup)));
        return registryObject;
    }

    public static <T extends Block> RegistryObject<T> register(String id, Supplier<T> blockSupplier, Rarity rarity) {
        RegistryObject registryObject = BLOCKS.register(id, blockSupplier);
        TCItems.ITEMS.register(id, () -> new BlockItem((Block)registryObject.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b).func_208103_a(rarity)));
        return registryObject;
    }
}

