/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.capability.CapabilityAbilityContainer;

public class AbilityContainerProvider
implements ICapabilitySerializable<CompoundNBT> {
    public final IAbilityContainer container;
    public final LazyOptional<IAbilityContainer> lazyOptional;

    public AbilityContainerProvider(IAbilityContainer container) {
        this.container = container;
        this.lazyOptional = LazyOptional.of(() -> container);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CapabilityAbilityContainer.ABILITY_CONTAINER ? this.lazyOptional : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        if (this.container instanceof INBTSerializable) {
            return (CompoundNBT)((INBTSerializable)this.container).serializeNBT();
        }
        return new CompoundNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        if (this.container instanceof INBTSerializable) {
            ((INBTSerializable)this.container).deserializeNBT((INBT)nbt);
        }
    }
}

