/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.gui.ability;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.IAbilityContainer;
import net.threetag.threecore.client.gui.ability.AbilityTabEntry;
import net.threetag.threecore.client.gui.ability.AbilityTabGui;

public class AbilitiesScreen
extends Screen {
    public static final ResourceLocation WINDOW = new ResourceLocation("threecore", "textures/gui/abilities/window.png");
    public static final ResourceLocation TABS = new ResourceLocation("threecore", "textures/gui/abilities/tabs.png");
    public static final ResourceLocation WIDGETS = new ResourceLocation("threecore", "textures/gui/abilities/widgets.png");
    private final int guiWidth = 252;
    private final int guiHeight = 196;
    private List<AbilityTabGui> tabs = Lists.newLinkedList();
    private AbilityTabGui selectedTab = null;
    public Screen overlayScreen = null;
    private boolean isScrolling;

    public AbilitiesScreen() {
        super(NarratorChatListener.field_216868_a);
        this.tabs.clear();
        this.selectedTab = null;
        AtomicInteger index = new AtomicInteger();
        AbilityHelper.getAbilityContainerList().forEach(f -> {
            IAbilityContainer container = (IAbilityContainer)f.apply(Minecraft.func_71410_x().field_71439_g);
            if (container != null && !container.getAbilities().isEmpty()) {
                this.tabs.add(AbilityTabGui.create(Minecraft.func_71410_x(), this, index.get(), container));
                index.getAndIncrement();
            }
        });
    }

    protected void init() {
        super.init();
        if (this.overlayScreen != null) {
            this.overlayScreen.init(this.minecraft, this.width, this.height);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int type) {
        if (type == 0) {
            AbilityTabEntry entry;
            int i = (this.width - 252) / 2;
            int j = (this.height - 196) / 2;
            if (this.isOverOverlayScreen(mouseX, mouseY)) {
                return this.overlayScreen.mouseClicked(mouseX, mouseY, type);
            }
            for (AbilityTabGui tab : this.tabs) {
                if (!tab.isMouseOver(i, j, mouseX, mouseY)) continue;
                this.selectedTab = tab;
                break;
            }
            if (this.selectedTab != null && (entry = this.selectedTab.getAbilityHoveredOver((int)(mouseX - (double)i - 9.0), (int)(mouseY - (double)j - 18.0), i, j)) != null) {
                this.overlayScreen = entry.getScreen(this);
                if (this.overlayScreen != null) {
                    this.overlayScreen.init(this.minecraft, this.width, this.height);
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, type);
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double x, double y) {
        if (p_mouseDragged_5_ != 0) {
            this.isScrolling = false;
            return false;
        }
        if (!this.isScrolling) {
            this.isScrolling = true;
        } else if (this.selectedTab != null) {
            this.selectedTab.scroll(x, y);
        }
        return true;
    }

    public boolean keyPressed(int type, int scanCode, int p_keyPressed_3_) {
        return this.overlayScreen == null ? super.keyPressed(type, scanCode, p_keyPressed_3_) : this.overlayScreen.keyPressed(type, scanCode, p_keyPressed_3_);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        int i = (this.width - 252) / 2;
        int j = (this.height - 196) / 2;
        this.renderBackground();
        this.renderInside(mouseX, mouseY, i, j);
        this.renderWindow(i, j);
        this.renderToolTips(mouseX, mouseY, i, j);
        if (this.overlayScreen != null) {
            RenderSystem.pushMatrix();
            RenderSystem.enableDepthTest();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
            this.overlayScreen.render(mouseX, mouseY, partialTicks);
            this.selectedTab.fade = MathHelper.func_76131_a((float)(this.selectedTab.fade + 0.02f), (float)0.0f, (float)0.5f);
            RenderSystem.popMatrix();
        }
    }

    public void renderWindow(int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.minecraft.func_110434_K().func_110577_a(WINDOW);
        this.blit(x, y, 0, 0, 252, 196);
        if (this.tabs.size() > 0) {
            this.minecraft.func_110434_K().func_110577_a(TABS);
            for (AbilityTabGui tab : this.tabs) {
                tab.drawTab(x, y, tab == this.selectedTab);
            }
            RenderSystem.enableRescaleNormal();
            RenderSystem.defaultBlendFunc();
            for (AbilityTabGui tab : this.tabs) {
                tab.drawIcon(x, y);
            }
            RenderSystem.disableBlend();
        }
        this.font.func_211126_b(I18n.func_135052_a((String)"gui.threecore.abilities", (Object[])new Object[0]), (float)(x + 8), (float)(y + 6), 0x404040);
    }

    private void renderInside(int mouseX, int mouseY, int x, int y) {
        AbilityTabGui tab = this.selectedTab;
        if (tab == null) {
            AbilitiesScreen.fill((int)(x + 9), (int)(y + 18), (int)(x + 9 + 234), (int)(y + 18 + 169), (int)-16777216);
            String s = I18n.func_135052_a((String)"advancements.empty", (Object[])new Object[0]);
            int i = this.font.func_78256_a(s);
            this.font.func_211126_b(s, (float)(x + 9 + 117 - i / 2), (float)(y + 18 + 56 - 4), -1);
            this.font.func_211126_b(":(", (float)(x + 9 + 117 - this.font.func_78256_a(":(") / 2), (float)(y + 18 + 113 - 9), -1);
        } else {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(x + 9), (float)(y + 18), (float)0.0f);
            RenderSystem.enableDepthTest();
            tab.drawContents();
            RenderSystem.popMatrix();
            RenderSystem.depthFunc((int)515);
            RenderSystem.disableDepthTest();
        }
    }

    private void renderToolTips(int mouseX, int mouseY, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectedTab != null) {
            RenderSystem.pushMatrix();
            RenderSystem.enableDepthTest();
            RenderSystem.translatef((float)(x + 9), (float)(y + 18), (float)400.0f);
            this.selectedTab.drawToolTips(mouseX - x - 9, mouseY - y - 18, x, y, this, this.overlayScreen != null);
            RenderSystem.disableDepthTest();
            RenderSystem.popMatrix();
        }
        if (this.overlayScreen == null && this.tabs.size() > 0) {
            for (AbilityTabGui tab : this.tabs) {
                if (!tab.isMouseOver(x, y, mouseX, mouseY)) continue;
                this.renderTooltip(tab.getTitle().func_150254_d(), mouseX, mouseY);
            }
        }
    }

    public boolean isOverOverlayScreen(double mouseX, double mouseY) {
        return this.overlayScreen != null;
    }
}

