/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.gui.ability;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;
import net.minecraftforge.fml.network.PacketDistributor;
import net.threetag.threecore.ThreeCore;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.widget.BackgroundlessButton;
import net.threetag.threecore.network.SetAbilityKeybindMessage;
import net.threetag.threecore.util.threedata.ThreeData;

public class AbilityScreen
extends Screen {
    public final Ability ability;
    public final AbilitiesScreen parentScreen;
    private final int guiWidth = 202;
    private final int guiHeight = 60;
    private boolean listenToKey = false;
    private Button keyButton;

    public AbilityScreen(Ability ability, AbilitiesScreen parentScreen) {
        super(ability.getDataManager().get(Ability.TITLE));
        this.ability = ability;
        this.parentScreen = parentScreen;
    }

    protected void init() {
        super.init();
        int i = (this.width - 202) / 2;
        int j = (this.height - 60) / 2;
        this.addButton((Widget)new BackgroundlessButton(i + 193, j + 3, 5, 5, TextFormatting.DARK_GRAY + "x", s -> {
            this.parentScreen.overlayScreen = null;
        }));
        if (this.ability.getConditionManager().needsKey()) {
            this.keyButton = (Button)this.addButton((Widget)new ExtendedButton(i + 143, j + 30, 50, 20, "/", b -> {
                this.listenToKey = !this.listenToKey;
                this.updateButton();
            }));
            this.updateButton();
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int i = (this.width - 202) / 2;
        int j = (this.height - 60) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(AbilitiesScreen.WINDOW);
        this.blit(i, j, 0, 196, this.guiWidth, this.guiHeight);
        this.font.func_211126_b(this.title.func_150254_d(), (float)(i + 8), (float)(j + 6), 0x404040);
        if (this.keyButton != null) {
            this.font.func_211126_b(I18n.func_135052_a((String)"gui.threecore.abilities.keybind", (Object[])new Object[0]), (float)(i + 143), (float)(j + 20), 0x404040);
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(i + 14), (float)(j + 18), (float)-70.0f);
        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
        this.ability.drawIcon(this.minecraft, (AbstractGui)this, 0, 0);
        RenderSystem.popMatrix();
        super.render(mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(int type, int scanCode, int p_keyPressed_3_) {
        if (this.keyButton != null && this.listenToKey) {
            this.ability.getDataManager().set((ThreeData)Ability.KEYBIND, (Object)InputMappings.func_197954_a((int)type, (int)scanCode).func_197937_c());
            ThreeCore.NETWORK_CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SetAbilityKeybindMessage(this.ability.container.getId(), this.ability.getId(), InputMappings.func_197954_a((int)type, (int)scanCode).func_197937_c()));
            this.listenToKey = false;
            this.updateButton();
        }
        return super.keyPressed(type, scanCode, p_keyPressed_3_);
    }

    public void updateButton() {
        String button = InputMappings.func_216507_a((int)this.ability.getDataManager().get(Ability.KEYBIND));
        if (button == null || button.isEmpty()) {
            button = "-";
        }
        this.keyButton.setMessage(this.listenToKey ? "> " + TextFormatting.YELLOW + button + TextFormatting.RESET + " <" : button);
    }
}

