/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.gui.ability;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.advancements.AdvancementState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.ability.condition.Condition;
import net.threetag.threecore.client.gui.ability.AbilitiesScreen;
import net.threetag.threecore.client.gui.ability.AbilityTabGui;
import net.threetag.threecore.util.icon.TexturedIcon;

public class AbilityTabEntry
extends AbstractGui {
    public static final TexturedIcon LOCKED_ICON = new TexturedIcon(AbilitiesScreen.WIDGETS, 90, 133, 16, 16);
    protected final Ability ability;
    protected double x;
    protected double y;
    private boolean unlocked;
    protected String title;
    private List<String> description;
    private final int width;
    List<AbilityTabEntry> parents = new LinkedList<AbilityTabEntry>();
    List<AbilityTabEntry> children = new LinkedList<AbilityTabEntry>();

    public AbilityTabEntry(Ability ability) {
        this.ability = ability;
        this.unlocked = ability.getConditionManager().isUnlocked();
        this.title = ability.getDataManager().get(Ability.TITLE).func_150254_d();
        this.description = this.getDescription();
        int i = this.getProgress() != null ? this.getProgress()[1] : 0;
        int j = String.valueOf(i).length();
        int k = i > 1 ? Minecraft.func_71410_x().field_71466_p.func_78256_a("  ") + Minecraft.func_71410_x().field_71466_p.func_78256_a("0") * j * 2 + Minecraft.func_71410_x().field_71466_p.func_78256_a("/") : 0;
        int l = 29 + Minecraft.func_71410_x().field_71466_p.func_78256_a(this.title) + k;
        for (String s1 : this.description) {
            l = Math.max(l, Minecraft.func_71410_x().field_71466_p.func_78256_a(s1));
        }
        this.width = l + 3 + 5;
    }

    public void drawDisplayIcon(Minecraft mc, int x, int y) {
        if (this.unlocked) {
            this.ability.drawIcon(mc, this, x, y);
        } else {
            LOCKED_ICON.draw(mc, x, y);
        }
    }

    public AbilityTabEntry updatePosition(double x, double y, AbilityTabGui gui) {
        this.x = x;
        this.y = gui.getFreeYPos(x, y);
        for (AbilityTabEntry child : this.children) {
            child.updatePosition(this.x + 1.0, y, gui);
        }
        return this;
    }

    public AbilityTabEntry updateRelatives(Collection<AbilityTabEntry> list) {
        this.parents.clear();
        this.children.clear();
        for (AbilityTabEntry entry : list) {
            List<Ability> parents = AbilityHelper.findParentAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g, this.ability, this.ability.container);
            List<Ability> children = AbilityHelper.findChildrenAbilities((LivingEntity)Minecraft.func_71410_x().field_71439_g, this.ability, this.ability.container);
            if (!parents.isEmpty() && parents.contains(entry.ability)) {
                this.parents.add(entry);
            }
            if (children.isEmpty() || !children.contains(entry.ability)) continue;
            this.children.add(entry);
        }
        return this;
    }

    public void drawIcon(Minecraft mc, int x, int y) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(AbilitiesScreen.WIDGETS);
        this.blit(x - 13, y - 13, 0, this.unlocked ? 128 : 154, 26, 26);
        this.drawDisplayIcon(mc, x - 8, y - 8);
    }

    public void drawHover(int x, int y, float fade, int p_191821_4_, int p_191821_5_, AbilitiesScreen gui) {
        AdvancementState advancementstate2;
        AdvancementState advancementstate1;
        AdvancementState advancementstate;
        boolean flag1;
        Minecraft minecraft = Minecraft.func_71410_x();
        int posX = (int)(this.x * 50.0) - 16;
        int posY = (int)(this.y * 50.0) - 13;
        boolean flag = p_191821_4_ + x + posX + this.width + 26 >= gui.width;
        int[] progress = this.getProgress();
        String s = progress != null ? progress[0] + "/" + progress[1] : null;
        int i = s == null ? 0 : minecraft.field_71466_p.func_78256_a(s);
        boolean bl = flag1 = 169 - y - posY - 26 <= 6 + this.description.size() * 9;
        float f = progress == null ? (this.unlocked ? 1.0f : 0.0f) : (float)progress[0] / (float)progress[1];
        int j = MathHelper.func_76141_d((float)(f * (float)this.width));
        if (f >= 1.0f) {
            j = this.width / 2;
            advancementstate = AdvancementState.OBTAINED;
            advancementstate1 = AdvancementState.OBTAINED;
            advancementstate2 = AdvancementState.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            advancementstate = AdvancementState.UNOBTAINED;
            advancementstate1 = AdvancementState.UNOBTAINED;
            advancementstate2 = AdvancementState.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            advancementstate = AdvancementState.OBTAINED;
            advancementstate1 = AdvancementState.OBTAINED;
            advancementstate2 = AdvancementState.UNOBTAINED;
        } else {
            advancementstate = AdvancementState.OBTAINED;
            advancementstate1 = AdvancementState.UNOBTAINED;
            advancementstate2 = AdvancementState.UNOBTAINED;
        }
        int k = this.width - j;
        minecraft.func_110434_K().func_110577_a(AbilitiesScreen.WIDGETS);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int l = y + posY;
        int i1 = flag ? x + posX - this.width + 26 + 6 : x + posX;
        int j1 = 32 + this.description.size() * 9;
        if (!this.description.isEmpty()) {
            if (flag1) {
                this.render9Sprite(i1, l + 26 - j1, this.width, j1, 10, 200, 26, 0, 52);
            } else {
                this.render9Sprite(i1, l, this.width, j1, 10, 200, 26, 0, 52);
            }
        }
        this.blit(i1, l, 0, advancementstate.func_192667_a() * 26, j, 26);
        this.blit(i1 + j, l, 200 - k, advancementstate1.func_192667_a() * 26, k, 26);
        this.blit(x + posX + 3, y + posY, 0, 128 + advancementstate2.func_192667_a() * 26, 26, 26);
        if (flag) {
            minecraft.field_71466_p.func_175063_a(this.title, (float)(i1 + 5), (float)(y + posY + 9), -1);
            if (s != null) {
                minecraft.field_71466_p.func_175063_a(s, (float)(x + posX - i), (float)(y + posY + 9), -1);
            }
        } else {
            minecraft.field_71466_p.func_175063_a(this.title, (float)(x + posX + 32), (float)(y + posY + 9), -1);
            if (s != null) {
                minecraft.field_71466_p.func_175063_a(s, (float)(x + posX + this.width - i - 5), (float)(y + posY + 9), -1);
            }
        }
        if (flag1) {
            for (int k1 = 0; k1 < this.description.size(); ++k1) {
                minecraft.field_71466_p.func_211126_b(this.description.get(k1), (float)(i1 + 5), (float)(l + 26 - j1 + 7 + k1 * 9), -5592406);
            }
        } else {
            for (int l1 = 0; l1 < this.description.size(); ++l1) {
                minecraft.field_71466_p.func_211126_b(this.description.get(l1), (float)(i1 + 5), (float)(y + posY + 9 + 17 + l1 * 9), -5592406);
            }
        }
        RenderHelper.func_227780_a_();
        this.drawDisplayIcon(minecraft, x + posX + 8, y + posY + 5);
    }

    protected void render9Sprite(int p_192994_1_, int p_192994_2_, int p_192994_3_, int p_192994_4_, int p_192994_5_, int p_192994_6_, int p_192994_7_, int p_192994_8_, int p_192994_9_) {
        this.blit(p_192994_1_, p_192994_2_, p_192994_8_, p_192994_9_, p_192994_5_, p_192994_5_);
        this.renderRepeating(p_192994_1_ + p_192994_5_, p_192994_2_, p_192994_3_ - p_192994_5_ - p_192994_5_, p_192994_5_, p_192994_8_ + p_192994_5_, p_192994_9_, p_192994_6_ - p_192994_5_ - p_192994_5_, p_192994_7_);
        this.blit(p_192994_1_ + p_192994_3_ - p_192994_5_, p_192994_2_, p_192994_8_ + p_192994_6_ - p_192994_5_, p_192994_9_, p_192994_5_, p_192994_5_);
        this.blit(p_192994_1_, p_192994_2_ + p_192994_4_ - p_192994_5_, p_192994_8_, p_192994_9_ + p_192994_7_ - p_192994_5_, p_192994_5_, p_192994_5_);
        this.renderRepeating(p_192994_1_ + p_192994_5_, p_192994_2_ + p_192994_4_ - p_192994_5_, p_192994_3_ - p_192994_5_ - p_192994_5_, p_192994_5_, p_192994_8_ + p_192994_5_, p_192994_9_ + p_192994_7_ - p_192994_5_, p_192994_6_ - p_192994_5_ - p_192994_5_, p_192994_7_);
        this.blit(p_192994_1_ + p_192994_3_ - p_192994_5_, p_192994_2_ + p_192994_4_ - p_192994_5_, p_192994_8_ + p_192994_6_ - p_192994_5_, p_192994_9_ + p_192994_7_ - p_192994_5_, p_192994_5_, p_192994_5_);
        this.renderRepeating(p_192994_1_, p_192994_2_ + p_192994_5_, p_192994_5_, p_192994_4_ - p_192994_5_ - p_192994_5_, p_192994_8_, p_192994_9_ + p_192994_5_, p_192994_6_, p_192994_7_ - p_192994_5_ - p_192994_5_);
        this.renderRepeating(p_192994_1_ + p_192994_5_, p_192994_2_ + p_192994_5_, p_192994_3_ - p_192994_5_ - p_192994_5_, p_192994_4_ - p_192994_5_ - p_192994_5_, p_192994_8_ + p_192994_5_, p_192994_9_ + p_192994_5_, p_192994_6_ - p_192994_5_ - p_192994_5_, p_192994_7_ - p_192994_5_ - p_192994_5_);
        this.renderRepeating(p_192994_1_ + p_192994_3_ - p_192994_5_, p_192994_2_ + p_192994_5_, p_192994_5_, p_192994_4_ - p_192994_5_ - p_192994_5_, p_192994_8_ + p_192994_6_ - p_192994_5_, p_192994_9_ + p_192994_5_, p_192994_6_, p_192994_7_ - p_192994_5_ - p_192994_5_);
    }

    protected void renderRepeating(int p_192993_1_, int p_192993_2_, int p_192993_3_, int p_192993_4_, int p_192993_5_, int p_192993_6_, int p_192993_7_, int p_192993_8_) {
        for (int i = 0; i < p_192993_3_; i += p_192993_7_) {
            int j = p_192993_1_ + i;
            int k = Math.min(p_192993_7_, p_192993_3_ - i);
            for (int l = 0; l < p_192993_4_; l += p_192993_8_) {
                int i1 = p_192993_2_ + l;
                int j1 = Math.min(p_192993_8_, p_192993_4_ - l);
                this.blit(j, i1, p_192993_5_, p_192993_6_, k, j1);
            }
        }
    }

    public int[] getProgress() {
        List<Condition> conditions = this.ability.getConditionManager().getFilteredConditions(false);
        int i = conditions.size();
        if (i <= 1) {
            return null;
        }
        int j = this.ability.getConditionManager().getFilteredConditions(false, true).size();
        return new int[]{j, i};
    }

    public List<String> getDescription() {
        LinkedList<String> list = new LinkedList<String>();
        List<Condition> conditions = this.ability.getConditionManager().getFilteredConditions(false);
        for (Condition condition : conditions) {
            boolean active = this.ability.getConditionManager().isActive(condition);
            list.add(condition.getDisplayName().func_150259_f().func_150255_a(new Style().func_150238_a(active ? TextFormatting.GREEN : TextFormatting.RED)).func_150254_d());
        }
        return list;
    }

    public boolean isMouseOver(int scrollX, int scrollY, int mouseX, int mouseY) {
        int i = (int)((double)scrollX + this.x * 50.0) - 13;
        int j = i + 26;
        int k = (int)((double)scrollY + this.y * 50.0) - 13;
        int l = k + 26;
        return mouseX >= i && mouseX <= j && mouseY >= k && mouseY <= l;
    }

    public Screen getScreen(AbilitiesScreen screen) {
        return this.ability.getScreen(screen);
    }
}

