/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerLoader;
import net.threetag.threecore.entity.ProjectileEntity;
import net.threetag.threecore.util.RenderUtil;

public class ProjectileEntityRenderer
extends SpriteRenderer<ProjectileEntity> {
    public ProjectileEntityRenderer(EntityRendererManager rendererManager, ItemRenderer itemRenderer) {
        super(rendererManager, itemRenderer, 1.0f, false);
    }

    public void render(ProjectileEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entity.getRenderedItem().func_190926_b()) {
            IModelLayer layer;
            if (entity.renderInfo.isEnergy()) {
                this.preRender(entity, matrixStackIn, bufferIn, entityYaw, partialTicks);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                IVertexBuilder vertexBuilder = bufferIn.getBuffer(RenderUtil.RenderTypes.LASER);
                RenderUtil.drawGlowingLine(matrixStackIn.func_227866_c_().func_227870_a_(), vertexBuilder, 1.0f, 0.05f, (float)entity.renderInfo.getColor().getRed() / 255.0f, (float)entity.renderInfo.getColor().getGreen() / 255.0f, (float)entity.renderInfo.getColor().getBlue() / 255.0f, 1.0f, 0xF00000);
                matrixStackIn.func_227865_b_();
            } else if (entity.renderInfo.getModelLayer() != null && (layer = ModelLayerLoader.getModelLayer(entity.renderInfo.getModelLayer())) != null) {
                this.preRender(entity, matrixStackIn, bufferIn, entityYaw, partialTicks);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                layer.render(new ModelLayerContext((Entity)entity), matrixStackIn, bufferIn, packedLightIn, null, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f);
                matrixStackIn.func_227865_b_();
            }
        } else {
            super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    private void preRender(ProjectileEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, float entityYaw, float partialTicks) {
        matrixStack.func_227860_a_();
        Vec3d vec1 = new Vec3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
        Vec3d vec2 = new Vec3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        vec1 = vec2.func_178788_d(vec1);
        vec2 = vec2.func_178788_d(vec2);
        vec1 = vec1.func_72432_b();
        double x_ = vec2.field_72450_a - vec1.field_72450_a;
        double y_ = vec2.field_72448_b - vec1.field_72448_b;
        double z_ = vec2.field_72449_c - vec1.field_72449_c;
        double diff = MathHelper.func_76133_a((double)(x_ * x_ + z_ * z_));
        float yaw = (float)(Math.atan2(z_, x_) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(y_, diff) * 180.0 / Math.PI));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-yaw));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(pitch));
    }
}

