/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.threecore.util.TCJsonUtil;

@OnlyIn(value=Dist.CLIENT)
public class EntityModelParser
implements Function<JsonObject, EntityModel> {
    @Override
    public EntityModel apply(JsonObject jsonObject) {
        ParsedModel model = new ParsedModel();
        model.field_78090_t = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"texture_width", (int)64);
        model.field_78089_u = JSONUtils.func_151208_a((JsonObject)jsonObject, (String)"texture_height", (int)32);
        if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"cubes")) {
            JsonArray cubes = JSONUtils.func_151214_t((JsonObject)jsonObject, (String)"cubes");
            for (int i = 0; i < cubes.size(); ++i) {
                JsonObject cubeJson = cubes.get(i).getAsJsonObject();
                model.addCube(EntityModelParser.parseRendererModel(cubeJson, (Model)model));
            }
        }
        return model;
    }

    public static ModelRenderer parseRendererModel(JsonObject json, Model model) {
        int[] textureOffsets = TCJsonUtil.getIntArray(json, 2, "texture_offset", 0, 0);
        ModelRenderer rendererModel = new ModelRenderer(model, textureOffsets[0], textureOffsets[1]);
        float[] offsets = TCJsonUtil.getFloatArray(json, 3, "offset", 0.0f, 0.0f, 0.0f);
        float[] rotationPoint = TCJsonUtil.getFloatArray(json, 3, "rotation_point", 0.0f, 0.0f, 0.0f);
        float[] rotation = TCJsonUtil.getFloatArray(json, 3, "rotation", 0.0f, 0.0f, 0.0f);
        int[] size = TCJsonUtil.getIntArray(json, 3, "size", 1, 1, 1);
        rendererModel.func_228301_a_(offsets[0], offsets[1], offsets[2], (float)size[0], (float)size[1], (float)size[2], JSONUtils.func_151221_a((JsonObject)json, (String)"scale", (float)0.0f));
        rendererModel.func_78793_a(rotationPoint[0], rotationPoint[1], rotationPoint[2]);
        rendererModel.field_78795_f = (float)Math.toRadians(rotation[0]);
        rendererModel.field_78796_g = (float)Math.toRadians(rotation[1]);
        rendererModel.field_78808_h = (float)Math.toRadians(rotation[2]);
        rendererModel.field_78809_i = JSONUtils.func_151209_a((JsonObject)json, (String)"mirror", (boolean)false);
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"children")) {
            JsonArray children = JSONUtils.func_151214_t((JsonObject)json, (String)"children");
            for (int i = 0; i < children.size(); ++i) {
                rendererModel.func_78792_a(EntityModelParser.parseRendererModel(children.get(i).getAsJsonObject(), model));
            }
        }
        return rendererModel;
    }

    public static class ParsedModel
    extends EntityModel {
        public List<ModelRenderer> cubes = Lists.newLinkedList();

        public ParsedModel(List<ModelRenderer> cubes) {
            this.cubes = cubes;
        }

        public ParsedModel() {
        }

        public ParsedModel addCube(ModelRenderer rendererModel) {
            this.cubes.add(rendererModel);
            return this;
        }

        public void func_225597_a_(Entity entity, float v, float v1, float v2, float v3, float v4) {
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            RenderSystem.enableBlend();
            for (ModelRenderer cube : this.cubes) {
                cube.func_228309_a_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            RenderSystem.disableBlend();
        }
    }
}

