/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.HandSide;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.threetag.threecore.client.renderer.entity.model.IArmRenderingModel;
import net.threetag.threecore.client.renderer.entity.model.ISlotDependentVisibility;
import net.threetag.threecore.client.renderer.entity.model.ModelRegistry;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerManager;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;
import net.threetag.threecore.client.renderer.entity.modellayer.texture.ModelLayerTexture;
import net.threetag.threecore.util.RenderUtil;

public class ModelLayer
implements IModelLayer {
    public final LazyValue<Model> model;
    public final ModelLayerTexture texture;
    public final List<IModelLayerPredicate> glowPredicates;
    public final List<IModelLayerPredicate> predicateList = Lists.newLinkedList();

    public ModelLayer(LazyValue<Model> model, ModelLayerTexture texture, List<IModelLayerPredicate> glowPredicates) {
        this.model = Objects.requireNonNull(model);
        this.texture = Objects.requireNonNull(texture);
        this.glowPredicates = glowPredicates;
    }

    @Override
    public void render(IModelLayerContext context, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLight, IEntityRenderer<? extends Entity, ? extends EntityModel<?>> entityRenderer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Model model = this.getModel(context);
        if (model instanceof BipedModel && entityRenderer.func_217764_d() instanceof BipedModel && context.getAsEntity() instanceof LivingEntity) {
            BipedModel bipedModel = (BipedModel)model;
            ((BipedModel)entityRenderer.func_217764_d()).func_217148_a(bipedModel);
            if (entityRenderer != null) {
                bipedModel.field_187076_m = ((BipedModel)entityRenderer.func_217764_d()).field_187076_m;
                bipedModel.field_187075_l = ((BipedModel)entityRenderer.func_217764_d()).field_187075_l;
            }
            if (context.getSlot() != null) {
                this.setModelSlotVisible(bipedModel, context.getSlot());
            }
            bipedModel.func_212843_a_((LivingEntity)context.getAsEntity(), limbSwing, limbSwingAmount, partialTicks);
            bipedModel.func_225597_a_((LivingEntity)context.getAsEntity(), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            boolean glow = ModelLayerManager.arePredicatesFulFilled(this.glowPredicates, context);
            IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)(glow ? RenderUtil.RenderTypes.getGlowing(this.getTexture(context).getTexture(context)) : RenderType.func_228644_e_((ResourceLocation)this.getTexture(context).getTexture(context))), (boolean)false, (boolean)false);
            bipedModel.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (model instanceof EntityModel) {
            boolean glow = ModelLayerManager.arePredicatesFulFilled(this.glowPredicates, context);
            ((EntityModel)model).func_212843_a_(context.getAsEntity(), limbSwing, limbSwingAmount, partialTicks);
            IVertexBuilder ivertexbuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)(glow ? RenderUtil.RenderTypes.getGlowing(this.getTexture(context).getTexture(context)) : RenderUtil.RenderTypes.func_228644_e_((ResourceLocation)this.getTexture(context).getTexture(context))), (boolean)false, (boolean)false);
            model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void renderArm(HandSide handSide, IModelLayerContext context, PlayerRenderer playerRenderer, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        Model model = this.getModel(context);
        if (model instanceof BipedModel && context.getAsEntity() instanceof PlayerEntity) {
            BipedModel bipedModel = (BipedModel)model;
            bipedModel.field_217112_c = 0.0f;
            bipedModel.field_228270_o_ = false;
            bipedModel.field_205061_a = 0.0f;
            bipedModel.func_225597_a_((LivingEntity)context.getAsEntity(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            boolean glow = ModelLayerManager.arePredicatesFulFilled(this.glowPredicates, context);
            IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)(glow ? RenderUtil.RenderTypes.getGlowing(this.getTexture(context).getTexture(context)) : RenderType.func_228644_e_((ResourceLocation)this.getTexture(context).getTexture(context))), (boolean)false, (boolean)false);
            if (context.getSlot() != null) {
                this.setModelSlotVisible(bipedModel, context.getSlot());
            }
            if (bipedModel instanceof IArmRenderingModel) {
                ((IArmRenderingModel)bipedModel).renderArm(handSide, matrixStack, vertexBuilder, packedLight);
            } else if (handSide == HandSide.RIGHT) {
                bipedModel.field_178723_h.field_78795_f = 0.0f;
                bipedModel.field_178723_h.func_228308_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_);
            } else {
                bipedModel.field_178724_i.field_78795_f = 0.0f;
                bipedModel.field_178724_i.func_228308_a_(matrixStack, vertexBuilder, packedLight, OverlayTexture.field_229196_a_);
            }
        }
    }

    public Model getModel(IModelLayerContext context) {
        return (Model)this.model.func_179281_c();
    }

    public ModelLayerTexture getTexture(IModelLayerContext context) {
        return this.texture;
    }

    @Override
    public boolean isActive(IModelLayerContext context) {
        return ModelLayerManager.arePredicatesFulFilled(this.predicateList, context);
    }

    @Override
    public ModelLayer addPredicate(IModelLayerPredicate predicate) {
        this.predicateList.add(predicate);
        return this;
    }

    protected void setModelSlotVisible(BipedModel model, EquipmentSlotType slotIn) {
        if (model instanceof ISlotDependentVisibility) {
            ((ISlotDependentVisibility)model).setSlotVisibility(slotIn);
        } else {
            model.func_178719_a(false);
            switch (slotIn) {
                case HEAD: {
                    model.field_78116_c.field_78806_j = true;
                    model.field_178720_f.field_78806_j = true;
                    break;
                }
                case CHEST: {
                    model.field_78115_e.field_78806_j = true;
                    model.field_178723_h.field_78806_j = true;
                    model.field_178724_i.field_78806_j = true;
                    break;
                }
                case LEGS: {
                    model.field_78115_e.field_78806_j = true;
                    model.field_178721_j.field_78806_j = true;
                    model.field_178722_k.field_78806_j = true;
                    break;
                }
                case FEET: {
                    model.field_178721_j.field_78806_j = true;
                    model.field_178722_k.field_78806_j = true;
                }
            }
        }
    }

    public static ModelLayer parse(JsonObject json) {
        LinkedList glowPredicates = Lists.newLinkedList();
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"glow")) {
            JsonElement glowJson = json.get("glow");
            if (glowJson.isJsonPrimitive() && glowJson.getAsBoolean()) {
                glowPredicates.add(c -> true);
            } else {
                JsonArray predicateArray = JSONUtils.func_151214_t((JsonObject)json, (String)"glow");
                for (int i = 0; i < predicateArray.size(); ++i) {
                    IModelLayerPredicate predicate = ModelLayerManager.parsePredicate(predicateArray.get(i).getAsJsonObject());
                    if (predicate == null) continue;
                    glowPredicates.add(predicate);
                }
            }
        } else {
            glowPredicates.add(c -> false);
        }
        return new ModelLayer((LazyValue<Model>)new LazyValue(() -> ModelRegistry.getModel(JSONUtils.func_151200_h((JsonObject)json, (String)"model"))), ModelLayerTexture.parse(json.get("texture")), glowPredicates);
    }
}

