/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.threetag.threecore.ability.Ability;
import net.threetag.threecore.ability.AbilityHelper;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayer;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerProvider;
import net.threetag.threecore.client.renderer.entity.modellayer.ModelLayerContext;

@Mod.EventBusSubscriber(modid="threecore", value={Dist.CLIENT})
public class ModelLayerRenderer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static ArrayList<Class<? extends LivingEntity>> entitiesWithLayer = new ArrayList();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderEntityPre(RenderLivingEvent.Pre e) {
        if (!entitiesWithLayer.contains(e.getEntity().getClass())) {
            e.getRenderer().func_177094_a(new ModelLayerRenderer(e.getRenderer()));
            entitiesWithLayer.add(e.getEntity().getClass());
        }
    }

    public ModelLayerRenderer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLightIn, T entityIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderItemLayers(matrixStack, renderTypeBuffer, packedLightIn, entityIn, EquipmentSlotType.HEAD, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.renderItemLayers(matrixStack, renderTypeBuffer, packedLightIn, entityIn, EquipmentSlotType.CHEST, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.renderItemLayers(matrixStack, renderTypeBuffer, packedLightIn, entityIn, EquipmentSlotType.LEGS, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        this.renderItemLayers(matrixStack, renderTypeBuffer, packedLightIn, entityIn, EquipmentSlotType.FEET, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        ModelLayerContext context = new ModelLayerContext((Entity)entityIn);
        for (Ability ability : AbilityHelper.getAbilities(entityIn)) {
            if (!(ability instanceof IModelLayerProvider) || !ability.getConditionManager().isEnabled()) continue;
            this.renderLayers(matrixStack, renderTypeBuffer, packedLightIn, (IModelLayerProvider)((Object)ability), context, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public void renderItemLayers(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int packedLightIn, T entity, EquipmentSlotType slot, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = entity.func_184582_a(slot);
        ModelLayerContext context = new ModelLayerContext((LivingEntity)entity, stack, slot);
        if (stack.func_77973_b() instanceof IModelLayerProvider) {
            for (IModelLayer layer : ((IModelLayerProvider)stack.func_77973_b()).getModelLayers(context)) {
                if (!layer.isActive(context)) continue;
                layer.render(context, matrixStack, renderTypeBuffer, packedLightIn, this.field_215335_a, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }

    public void renderLayers(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int i, IModelLayerProvider provider, IModelLayerContext context, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        for (IModelLayer layer : provider.getModelLayers(context)) {
            if (!layer.isActive(context)) continue;
            layer.render(context, matrixStack, renderTypeBuffer, i, this.field_215335_a, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

