/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer.predicates;

import com.google.gson.JsonObject;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;

public class IntegerNbtPredicate
implements IModelLayerPredicate {
    private final String tag;
    private final int min;
    private final int max;

    public IntegerNbtPredicate(String tag, int min, int max) {
        this.tag = tag;
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(IModelLayerContext context) {
        CompoundNBT nbt = context.getAsItem() != null && !context.getAsItem().func_190926_b() ? context.getAsItem().func_196082_o() : context.getAsEntity().getPersistentData();
        int i = nbt.func_74762_e(this.tag);
        return i >= this.min && i <= this.max;
    }

    public static IntegerNbtPredicate parse(JsonObject json) {
        String tag = JSONUtils.func_151200_h((JsonObject)json, (String)"nbt_tag");
        if (JSONUtils.func_151204_g((JsonObject)json, (String)"value")) {
            return new IntegerNbtPredicate(tag, JSONUtils.func_151203_m((JsonObject)json, (String)"value"), JSONUtils.func_151203_m((JsonObject)json, (String)"value"));
        }
        return new IntegerNbtPredicate(tag, JSONUtils.func_151203_m((JsonObject)json, (String)"min"), JSONUtils.func_151203_m((JsonObject)json, (String)"max"));
    }
}

