/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.threecore.client.renderer.entity.modellayer.predicates;

import java.util.concurrent.atomic.AtomicInteger;
import net.threetag.threecore.capability.CapabilityKarma;
import net.threetag.threecore.client.renderer.entity.modellayer.IModelLayerContext;
import net.threetag.threecore.client.renderer.entity.modellayer.predicates.IModelLayerPredicate;

public class KarmaPredicate
implements IModelLayerPredicate {
    public final int min;
    public final int max;

    public KarmaPredicate(int min, int max) {
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalStateException("Min karma value cant be bigger than max karma value!");
        }
    }

    @Override
    public boolean test(IModelLayerContext context) {
        AtomicInteger karmaVal = new AtomicInteger(0);
        context.getAsEntity().getCapability(CapabilityKarma.KARMA).ifPresent(karma -> karmaVal.set(karma.getKarma()));
        return karmaVal.get() >= this.min && karmaVal.get() <= this.max;
    }
}

